package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SmsShortUrlTaskQuery invokes the retailadvqa_public.SmsShortUrlTaskQuery API synchronously
func (client *Client) SmsShortUrlTaskQuery(request *SmsShortUrlTaskQueryRequest) (response *SmsShortUrlTaskQueryResponse, err error) {
	response = CreateSmsShortUrlTaskQueryResponse()
	err = client.DoAction(request, response)
	return
}

// SmsShortUrlTaskQueryWithChan invokes the retailadvqa_public.SmsShortUrlTaskQuery API asynchronously
func (client *Client) SmsShortUrlTaskQueryWithChan(request *SmsShortUrlTaskQueryRequest) (<-chan *SmsShortUrlTaskQueryResponse, <-chan error) {
	responseChan := make(chan *SmsShortUrlTaskQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SmsShortUrlTaskQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SmsShortUrlTaskQueryWithCallback invokes the retailadvqa_public.SmsShortUrlTaskQuery API asynchronously
func (client *Client) SmsShortUrlTaskQueryWithCallback(request *SmsShortUrlTaskQueryRequest, callback func(response *SmsShortUrlTaskQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SmsShortUrlTaskQueryResponse
		var err error
		defer close(result)
		response, err = client.SmsShortUrlTaskQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SmsShortUrlTaskQueryRequest is the request struct for api SmsShortUrlTaskQuery
type SmsShortUrlTaskQueryRequest struct {
	*requests.RpcRequest
	AccessId    string           `position:"Query" name:"AccessId"`
	PrivateKey  string           `position:"Query" name:"PrivateKey"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	PageNum     requests.Integer `position:"Query" name:"PageNum"`
	WorkspaceId string           `position:"Query" name:"WorkspaceId"`
}

// SmsShortUrlTaskQueryResponse is the response struct for api SmsShortUrlTaskQuery
type SmsShortUrlTaskQueryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSmsShortUrlTaskQueryRequest creates a request to invoke SmsShortUrlTaskQuery API
func CreateSmsShortUrlTaskQueryRequest() (request *SmsShortUrlTaskQueryRequest) {
	request = &SmsShortUrlTaskQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "SmsShortUrlTaskQuery", "", "")
	request.Method = requests.POST
	return
}

// CreateSmsShortUrlTaskQueryResponse creates a response to parse from SmsShortUrlTaskQuery response
func CreateSmsShortUrlTaskQueryResponse() (response *SmsShortUrlTaskQueryResponse) {
	response = &SmsShortUrlTaskQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
