package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAudience invokes the retailadvqa_public.ListAudience API synchronously
func (client *Client) ListAudience(request *ListAudienceRequest) (response *ListAudienceResponse, err error) {
	response = CreateListAudienceResponse()
	err = client.DoAction(request, response)
	return
}

// ListAudienceWithChan invokes the retailadvqa_public.ListAudience API asynchronously
func (client *Client) ListAudienceWithChan(request *ListAudienceRequest) (<-chan *ListAudienceResponse, <-chan error) {
	responseChan := make(chan *ListAudienceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAudience(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAudienceWithCallback invokes the retailadvqa_public.ListAudience API asynchronously
func (client *Client) ListAudienceWithCallback(request *ListAudienceRequest, callback func(response *ListAudienceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAudienceResponse
		var err error
		defer close(result)
		response, err = client.ListAudience(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAudienceRequest is the request struct for api ListAudience
type ListAudienceRequest struct {
	*requests.RpcRequest
	PageNum     string `position:"Query" name:"PageNum"`
	ColumnName  string `position:"Query" name:"ColumnName"`
	UserId      string `position:"Query" name:"UserId"`
	AccessId    string `position:"Query" name:"AccessId"`
	Name        string `position:"Query" name:"Name"`
	PageSize    string `position:"Query" name:"PageSize"`
	TenantId    string `position:"Query" name:"TenantId"`
	Order       string `position:"Query" name:"Order"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// ListAudienceResponse is the response struct for api ListAudience
type ListAudienceResponse struct {
	*responses.BaseResponse
	RequestId string             `json:"RequestId" xml:"RequestId"`
	ErrorDesc string             `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string             `json:"TraceId" xml:"TraceId"`
	ErrorCode string             `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool               `json:"Success" xml:"Success"`
	Data      DataInListAudience `json:"Data" xml:"Data"`
}

// CreateListAudienceRequest creates a request to invoke ListAudience API
func CreateListAudienceRequest() (request *ListAudienceRequest) {
	request = &ListAudienceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ListAudience", "", "")
	request.Method = requests.GET
	return
}

// CreateListAudienceResponse creates a response to parse from ListAudience response
func CreateListAudienceResponse() (response *ListAudienceResponse) {
	response = &ListAudienceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
