package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteImportTask invokes the retailadvqa_public.ExecuteImportTask API synchronously
func (client *Client) ExecuteImportTask(request *ExecuteImportTaskRequest) (response *ExecuteImportTaskResponse, err error) {
	response = CreateExecuteImportTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteImportTaskWithChan invokes the retailadvqa_public.ExecuteImportTask API asynchronously
func (client *Client) ExecuteImportTaskWithChan(request *ExecuteImportTaskRequest) (<-chan *ExecuteImportTaskResponse, <-chan error) {
	responseChan := make(chan *ExecuteImportTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteImportTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteImportTaskWithCallback invokes the retailadvqa_public.ExecuteImportTask API asynchronously
func (client *Client) ExecuteImportTaskWithCallback(request *ExecuteImportTaskRequest, callback func(response *ExecuteImportTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteImportTaskResponse
		var err error
		defer close(result)
		response, err = client.ExecuteImportTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteImportTaskRequest is the request struct for api ExecuteImportTask
type ExecuteImportTaskRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Query" name:"AccessId"`
	Date        string `position:"Body" name:"Date"`
	TenantId    string `position:"Query" name:"TenantId"`
	TaskId      string `position:"Body" name:"TaskId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// ExecuteImportTaskResponse is the response struct for api ExecuteImportTask
type ExecuteImportTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateExecuteImportTaskRequest creates a request to invoke ExecuteImportTask API
func CreateExecuteImportTaskRequest() (request *ExecuteImportTaskRequest) {
	request = &ExecuteImportTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ExecuteImportTask", "", "")
	request.Method = requests.POST
	return
}

// CreateExecuteImportTaskResponse creates a response to parse from ExecuteImportTask response
func CreateExecuteImportTaskResponse() (response *ExecuteImportTaskResponse) {
	response = &ExecuteImportTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
