package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConsumeMediaResourcePackage invokes the retailadvqa_public.ConsumeMediaResourcePackage API synchronously
func (client *Client) ConsumeMediaResourcePackage(request *ConsumeMediaResourcePackageRequest) (response *ConsumeMediaResourcePackageResponse, err error) {
	response = CreateConsumeMediaResourcePackageResponse()
	err = client.DoAction(request, response)
	return
}

// ConsumeMediaResourcePackageWithChan invokes the retailadvqa_public.ConsumeMediaResourcePackage API asynchronously
func (client *Client) ConsumeMediaResourcePackageWithChan(request *ConsumeMediaResourcePackageRequest) (<-chan *ConsumeMediaResourcePackageResponse, <-chan error) {
	responseChan := make(chan *ConsumeMediaResourcePackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConsumeMediaResourcePackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConsumeMediaResourcePackageWithCallback invokes the retailadvqa_public.ConsumeMediaResourcePackage API asynchronously
func (client *Client) ConsumeMediaResourcePackageWithCallback(request *ConsumeMediaResourcePackageRequest, callback func(response *ConsumeMediaResourcePackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConsumeMediaResourcePackageResponse
		var err error
		defer close(result)
		response, err = client.ConsumeMediaResourcePackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConsumeMediaResourcePackageRequest is the request struct for api ConsumeMediaResourcePackage
type ConsumeMediaResourcePackageRequest struct {
	*requests.RpcRequest
	ConsumeType  string           `position:"Query" name:"ConsumeType"`
	ProductId    string           `position:"Query" name:"ProductId"`
	ConsumeInfos string           `position:"Query" name:"ConsumeInfos"`
	ConsumeTime  requests.Integer `position:"Query" name:"ConsumeTime"`
}

// ConsumeMediaResourcePackageResponse is the response struct for api ConsumeMediaResourcePackage
type ConsumeMediaResourcePackageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateConsumeMediaResourcePackageRequest creates a request to invoke ConsumeMediaResourcePackage API
func CreateConsumeMediaResourcePackageRequest() (request *ConsumeMediaResourcePackageRequest) {
	request = &ConsumeMediaResourcePackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ConsumeMediaResourcePackage", "", "")
	request.Method = requests.POST
	return
}

// CreateConsumeMediaResourcePackageResponse creates a response to parse from ConsumeMediaResourcePackage response
func CreateConsumeMediaResourcePackageResponse() (response *ConsumeMediaResourcePackageResponse) {
	response = &ConsumeMediaResourcePackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
