package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AudienceDetailById invokes the retailadvqa_public.AudienceDetailById API synchronously
func (client *Client) AudienceDetailById(request *AudienceDetailByIdRequest) (response *AudienceDetailByIdResponse, err error) {
	response = CreateAudienceDetailByIdResponse()
	err = client.DoAction(request, response)
	return
}

// AudienceDetailByIdWithChan invokes the retailadvqa_public.AudienceDetailById API asynchronously
func (client *Client) AudienceDetailByIdWithChan(request *AudienceDetailByIdRequest) (<-chan *AudienceDetailByIdResponse, <-chan error) {
	responseChan := make(chan *AudienceDetailByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AudienceDetailById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AudienceDetailByIdWithCallback invokes the retailadvqa_public.AudienceDetailById API asynchronously
func (client *Client) AudienceDetailByIdWithCallback(request *AudienceDetailByIdRequest, callback func(response *AudienceDetailByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AudienceDetailByIdResponse
		var err error
		defer close(result)
		response, err = client.AudienceDetailById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AudienceDetailByIdRequest is the request struct for api AudienceDetailById
type AudienceDetailByIdRequest struct {
	*requests.RpcRequest
	AccessId   string `position:"Query" name:"AccessId"`
	TenantId   string `position:"Query" name:"TenantId"`
	AudienceId string `position:"Query" name:"AudienceId"`
}

// AudienceDetailByIdResponse is the response struct for api AudienceDetailById
type AudienceDetailByIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAudienceDetailByIdRequest creates a request to invoke AudienceDetailById API
func CreateAudienceDetailByIdRequest() (request *AudienceDetailByIdRequest) {
	request = &AudienceDetailByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "AudienceDetailById", "", "")
	request.Method = requests.POST
	return
}

// CreateAudienceDetailByIdResponse creates a response to parse from AudienceDetailById response
func CreateAudienceDetailByIdResponse() (response *AudienceDetailByIdResponse) {
	response = &AudienceDetailByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
