package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExampleQueries invokes the resourcecenter.ListExampleQueries API synchronously
func (client *Client) ListExampleQueries(request *ListExampleQueriesRequest) (response *ListExampleQueriesResponse, err error) {
	response = CreateListExampleQueriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListExampleQueriesWithChan invokes the resourcecenter.ListExampleQueries API asynchronously
func (client *Client) ListExampleQueriesWithChan(request *ListExampleQueriesRequest) (<-chan *ListExampleQueriesResponse, <-chan error) {
	responseChan := make(chan *ListExampleQueriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExampleQueries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExampleQueriesWithCallback invokes the resourcecenter.ListExampleQueries API asynchronously
func (client *Client) ListExampleQueriesWithCallback(request *ListExampleQueriesRequest, callback func(response *ListExampleQueriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExampleQueriesResponse
		var err error
		defer close(result)
		response, err = client.ListExampleQueries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExampleQueriesRequest is the request struct for api ListExampleQueries
type ListExampleQueriesRequest struct {
	*requests.RpcRequest
	NextToken  string `position:"Query" name:"NextToken"`
	MaxResults string `position:"Query" name:"MaxResults"`
}

// ListExampleQueriesResponse is the response struct for api ListExampleQueries
type ListExampleQueriesResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	MaxResults     string         `json:"MaxResults" xml:"MaxResults"`
	NextToken      string         `json:"NextToken" xml:"NextToken"`
	ExampleQueries []ExampleQuery `json:"ExampleQueries" xml:"ExampleQueries"`
}

// CreateListExampleQueriesRequest creates a request to invoke ListExampleQueries API
func CreateListExampleQueriesRequest() (request *ListExampleQueriesRequest) {
	request = &ListExampleQueriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "ListExampleQueries", "", "")
	request.Method = requests.POST
	return
}

// CreateListExampleQueriesResponse creates a response to parse from ListExampleQueries response
func CreateListExampleQueriesResponse() (response *ListExampleQueriesResponse) {
	response = &ListExampleQueriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
