package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisassociateDefaultFilter invokes the resourcecenter.DisassociateDefaultFilter API synchronously
func (client *Client) DisassociateDefaultFilter(request *DisassociateDefaultFilterRequest) (response *DisassociateDefaultFilterResponse, err error) {
	response = CreateDisassociateDefaultFilterResponse()
	err = client.DoAction(request, response)
	return
}

// DisassociateDefaultFilterWithChan invokes the resourcecenter.DisassociateDefaultFilter API asynchronously
func (client *Client) DisassociateDefaultFilterWithChan(request *DisassociateDefaultFilterRequest) (<-chan *DisassociateDefaultFilterResponse, <-chan error) {
	responseChan := make(chan *DisassociateDefaultFilterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisassociateDefaultFilter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisassociateDefaultFilterWithCallback invokes the resourcecenter.DisassociateDefaultFilter API asynchronously
func (client *Client) DisassociateDefaultFilterWithCallback(request *DisassociateDefaultFilterRequest, callback func(response *DisassociateDefaultFilterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisassociateDefaultFilterResponse
		var err error
		defer close(result)
		response, err = client.DisassociateDefaultFilter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisassociateDefaultFilterRequest is the request struct for api DisassociateDefaultFilter
type DisassociateDefaultFilterRequest struct {
	*requests.RpcRequest
}

// DisassociateDefaultFilterResponse is the response struct for api DisassociateDefaultFilter
type DisassociateDefaultFilterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisassociateDefaultFilterRequest creates a request to invoke DisassociateDefaultFilter API
func CreateDisassociateDefaultFilterRequest() (request *DisassociateDefaultFilterRequest) {
	request = &DisassociateDefaultFilterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "DisassociateDefaultFilter", "", "")
	request.Method = requests.POST
	return
}

// CreateDisassociateDefaultFilterResponse creates a response to parse from DisassociateDefaultFilter response
func CreateDisassociateDefaultFilterResponse() (response *DisassociateDefaultFilterResponse) {
	response = &DisassociateDefaultFilterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
