package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDatabaseConfig invokes the rds.ModifyDatabaseConfig API synchronously
func (client *Client) ModifyDatabaseConfig(request *ModifyDatabaseConfigRequest) (response *ModifyDatabaseConfigResponse, err error) {
	response = CreateModifyDatabaseConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDatabaseConfigWithChan invokes the rds.ModifyDatabaseConfig API asynchronously
func (client *Client) ModifyDatabaseConfigWithChan(request *ModifyDatabaseConfigRequest) (<-chan *ModifyDatabaseConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyDatabaseConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDatabaseConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDatabaseConfigWithCallback invokes the rds.ModifyDatabaseConfig API asynchronously
func (client *Client) ModifyDatabaseConfigWithCallback(request *ModifyDatabaseConfigRequest, callback func(response *ModifyDatabaseConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDatabaseConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyDatabaseConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDatabaseConfigRequest is the request struct for api ModifyDatabaseConfig
type ModifyDatabaseConfigRequest struct {
	*requests.RpcRequest
	DatabasePropertyValue string           `position:"Query" name:"DatabasePropertyValue"`
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken           string           `position:"Query" name:"ClientToken"`
	DatabasePropertyName  string           `position:"Query" name:"DatabasePropertyName"`
	ResourceGroupId       string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceId          string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	DBName                string           `position:"Query" name:"DBName"`
}

// ModifyDatabaseConfigResponse is the response struct for api ModifyDatabaseConfig
type ModifyDatabaseConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateModifyDatabaseConfigRequest creates a request to invoke ModifyDatabaseConfig API
func CreateModifyDatabaseConfigRequest() (request *ModifyDatabaseConfigRequest) {
	request = &ModifyDatabaseConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyDatabaseConfig", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDatabaseConfigResponse creates a response to parse from ModifyDatabaseConfig response
func CreateModifyDatabaseConfigResponse() (response *ModifyDatabaseConfigResponse) {
	response = &ModifyDatabaseConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
