package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHistoryEventsStat invokes the rds.DescribeHistoryEventsStat API synchronously
func (client *Client) DescribeHistoryEventsStat(request *DescribeHistoryEventsStatRequest) (response *DescribeHistoryEventsStatResponse, err error) {
	response = CreateDescribeHistoryEventsStatResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHistoryEventsStatWithChan invokes the rds.DescribeHistoryEventsStat API asynchronously
func (client *Client) DescribeHistoryEventsStatWithChan(request *DescribeHistoryEventsStatRequest) (<-chan *DescribeHistoryEventsStatResponse, <-chan error) {
	responseChan := make(chan *DescribeHistoryEventsStatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHistoryEventsStat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHistoryEventsStatWithCallback invokes the rds.DescribeHistoryEventsStat API asynchronously
func (client *Client) DescribeHistoryEventsStatWithCallback(request *DescribeHistoryEventsStatRequest, callback func(response *DescribeHistoryEventsStatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHistoryEventsStatResponse
		var err error
		defer close(result)
		response, err = client.DescribeHistoryEventsStat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHistoryEventsStatRequest is the request struct for api DescribeHistoryEventsStat
type DescribeHistoryEventsStatRequest struct {
	*requests.RpcRequest
	ToStartTime   string `position:"Query" name:"ToStartTime"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	FromStartTime string `position:"Query" name:"FromStartTime"`
	ArchiveStatus string `position:"Query" name:"ArchiveStatus"`
}

// DescribeHistoryEventsStatResponse is the response struct for api DescribeHistoryEventsStat
type DescribeHistoryEventsStatResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Items     []ItemsItem `json:"Items" xml:"Items"`
}

// CreateDescribeHistoryEventsStatRequest creates a request to invoke DescribeHistoryEventsStat API
func CreateDescribeHistoryEventsStatRequest() (request *DescribeHistoryEventsStatRequest) {
	request = &DescribeHistoryEventsStatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeHistoryEventsStat", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHistoryEventsStatResponse creates a response to parse from DescribeHistoryEventsStat response
func CreateDescribeHistoryEventsStatResponse() (response *DescribeHistoryEventsStatResponse) {
	response = &DescribeHistoryEventsStatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
