package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDTCSecurityIpHostsForSQLServer invokes the rds.DescribeDTCSecurityIpHostsForSQLServer API synchronously
func (client *Client) DescribeDTCSecurityIpHostsForSQLServer(request *DescribeDTCSecurityIpHostsForSQLServerRequest) (response *DescribeDTCSecurityIpHostsForSQLServerResponse, err error) {
	response = CreateDescribeDTCSecurityIpHostsForSQLServerResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDTCSecurityIpHostsForSQLServerWithChan invokes the rds.DescribeDTCSecurityIpHostsForSQLServer API asynchronously
func (client *Client) DescribeDTCSecurityIpHostsForSQLServerWithChan(request *DescribeDTCSecurityIpHostsForSQLServerRequest) (<-chan *DescribeDTCSecurityIpHostsForSQLServerResponse, <-chan error) {
	responseChan := make(chan *DescribeDTCSecurityIpHostsForSQLServerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDTCSecurityIpHostsForSQLServer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDTCSecurityIpHostsForSQLServerWithCallback invokes the rds.DescribeDTCSecurityIpHostsForSQLServer API asynchronously
func (client *Client) DescribeDTCSecurityIpHostsForSQLServerWithCallback(request *DescribeDTCSecurityIpHostsForSQLServerRequest, callback func(response *DescribeDTCSecurityIpHostsForSQLServerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDTCSecurityIpHostsForSQLServerResponse
		var err error
		defer close(result)
		response, err = client.DescribeDTCSecurityIpHostsForSQLServer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDTCSecurityIpHostsForSQLServerRequest is the request struct for api DescribeDTCSecurityIpHostsForSQLServer
type DescribeDTCSecurityIpHostsForSQLServerRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDTCSecurityIpHostsForSQLServerResponse is the response struct for api DescribeDTCSecurityIpHostsForSQLServer
type DescribeDTCSecurityIpHostsForSQLServerResponse struct {
	*responses.BaseResponse
	DBInstanceId  string                                        `json:"DBInstanceId" xml:"DBInstanceId"`
	RequestId     string                                        `json:"RequestId" xml:"RequestId"`
	IpHostPairNum string                                        `json:"IpHostPairNum" xml:"IpHostPairNum"`
	Items         ItemsInDescribeDTCSecurityIpHostsForSQLServer `json:"Items" xml:"Items"`
}

// CreateDescribeDTCSecurityIpHostsForSQLServerRequest creates a request to invoke DescribeDTCSecurityIpHostsForSQLServer API
func CreateDescribeDTCSecurityIpHostsForSQLServerRequest() (request *DescribeDTCSecurityIpHostsForSQLServerRequest) {
	request = &DescribeDTCSecurityIpHostsForSQLServerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeDTCSecurityIpHostsForSQLServer", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDTCSecurityIpHostsForSQLServerResponse creates a response to parse from DescribeDTCSecurityIpHostsForSQLServer response
func CreateDescribeDTCSecurityIpHostsForSQLServerResponse() (response *DescribeDTCSecurityIpHostsForSQLServerResponse) {
	response = &DescribeDTCSecurityIpHostsForSQLServerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
