package rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProjectMembers invokes the rdc.GetProjectMembers API synchronously
// api document: https://help.aliyun.com/api/rdc/getprojectmembers.html
func (client *Client) GetProjectMembers(request *GetProjectMembersRequest) (response *GetProjectMembersResponse, err error) {
	response = CreateGetProjectMembersResponse()
	err = client.DoAction(request, response)
	return
}

// GetProjectMembersWithChan invokes the rdc.GetProjectMembers API asynchronously
// api document: https://help.aliyun.com/api/rdc/getprojectmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProjectMembersWithChan(request *GetProjectMembersRequest) (<-chan *GetProjectMembersResponse, <-chan error) {
	responseChan := make(chan *GetProjectMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProjectMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProjectMembersWithCallback invokes the rdc.GetProjectMembers API asynchronously
// api document: https://help.aliyun.com/api/rdc/getprojectmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProjectMembersWithCallback(request *GetProjectMembersRequest, callback func(response *GetProjectMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProjectMembersResponse
		var err error
		defer close(result)
		response, err = client.GetProjectMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProjectMembersRequest is the request struct for api GetProjectMembers
type GetProjectMembersRequest struct {
	*requests.RpcRequest
	CorpIdentifier string           `position:"Query" name:"CorpIdentifier"`
	ProjectId      requests.Integer `position:"Query" name:"ProjectId"`
	StaffId        string           `position:"Query" name:"StaffId"`
}

// GetProjectMembersResponse is the response struct for api GetProjectMembers
type GetProjectMembersResponse struct {
	*responses.BaseResponse
	Code      int        `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Message   string     `json:"Message" xml:"Message"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetProjectMembersRequest creates a request to invoke GetProjectMembers API
func CreateGetProjectMembersRequest() (request *GetProjectMembersRequest) {
	request = &GetProjectMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rdc", "2018-08-21", "GetProjectMembers", "rdc", "openAPI")
	return
}

// CreateGetProjectMembersResponse creates a response to parse from GetProjectMembers response
func CreateGetProjectMembersResponse() (response *GetProjectMembersResponse) {
	response = &GetProjectMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
