package ram

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePolicyDescription invokes the ram.UpdatePolicyDescription API synchronously
func (client *Client) UpdatePolicyDescription(request *UpdatePolicyDescriptionRequest) (response *UpdatePolicyDescriptionResponse, err error) {
	response = CreateUpdatePolicyDescriptionResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePolicyDescriptionWithChan invokes the ram.UpdatePolicyDescription API asynchronously
func (client *Client) UpdatePolicyDescriptionWithChan(request *UpdatePolicyDescriptionRequest) (<-chan *UpdatePolicyDescriptionResponse, <-chan error) {
	responseChan := make(chan *UpdatePolicyDescriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePolicyDescription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePolicyDescriptionWithCallback invokes the ram.UpdatePolicyDescription API asynchronously
func (client *Client) UpdatePolicyDescriptionWithCallback(request *UpdatePolicyDescriptionRequest, callback func(response *UpdatePolicyDescriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePolicyDescriptionResponse
		var err error
		defer close(result)
		response, err = client.UpdatePolicyDescription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePolicyDescriptionRequest is the request struct for api UpdatePolicyDescription
type UpdatePolicyDescriptionRequest struct {
	*requests.RpcRequest
	PolicyName     string `position:"Query" name:"PolicyName"`
	NewDescription string `position:"Query" name:"NewDescription"`
}

// UpdatePolicyDescriptionResponse is the response struct for api UpdatePolicyDescription
type UpdatePolicyDescriptionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Policy    Policy `json:"Policy" xml:"Policy"`
}

// CreateUpdatePolicyDescriptionRequest creates a request to invoke UpdatePolicyDescription API
func CreateUpdatePolicyDescriptionRequest() (request *UpdatePolicyDescriptionRequest) {
	request = &UpdatePolicyDescriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ram", "2015-05-01", "UpdatePolicyDescription", "Ram", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdatePolicyDescriptionResponse creates a response to parse from UpdatePolicyDescription response
func CreateUpdatePolicyDescriptionResponse() (response *UpdatePolicyDescriptionResponse) {
	response = &UpdatePolicyDescriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
