package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopTairKVCacheCustomInstance invokes the r_kvstore.StopTairKVCacheCustomInstance API synchronously
func (client *Client) StopTairKVCacheCustomInstance(request *StopTairKVCacheCustomInstanceRequest) (response *StopTairKVCacheCustomInstanceResponse, err error) {
	response = CreateStopTairKVCacheCustomInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StopTairKVCacheCustomInstanceWithChan invokes the r_kvstore.StopTairKVCacheCustomInstance API asynchronously
func (client *Client) StopTairKVCacheCustomInstanceWithChan(request *StopTairKVCacheCustomInstanceRequest) (<-chan *StopTairKVCacheCustomInstanceResponse, <-chan error) {
	responseChan := make(chan *StopTairKVCacheCustomInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopTairKVCacheCustomInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopTairKVCacheCustomInstanceWithCallback invokes the r_kvstore.StopTairKVCacheCustomInstance API asynchronously
func (client *Client) StopTairKVCacheCustomInstanceWithCallback(request *StopTairKVCacheCustomInstanceRequest, callback func(response *StopTairKVCacheCustomInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopTairKVCacheCustomInstanceResponse
		var err error
		defer close(result)
		response, err = client.StopTairKVCacheCustomInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopTairKVCacheCustomInstanceRequest is the request struct for api StopTairKVCacheCustomInstance
type StopTairKVCacheCustomInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// StopTairKVCacheCustomInstanceResponse is the response struct for api StopTairKVCacheCustomInstance
type StopTairKVCacheCustomInstanceResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
	TaskId     string `json:"TaskId" xml:"TaskId"`
}

// CreateStopTairKVCacheCustomInstanceRequest creates a request to invoke StopTairKVCacheCustomInstance API
func CreateStopTairKVCacheCustomInstanceRequest() (request *StopTairKVCacheCustomInstanceRequest) {
	request = &StopTairKVCacheCustomInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "StopTairKVCacheCustomInstance", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopTairKVCacheCustomInstanceResponse creates a response to parse from StopTairKVCacheCustomInstance response
func CreateStopTairKVCacheCustomInstanceResponse() (response *StopTairKVCacheCustomInstanceResponse) {
	response = &StopTairKVCacheCustomInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
