package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyParameterGroup invokes the r_kvstore.ModifyParameterGroup API synchronously
func (client *Client) ModifyParameterGroup(request *ModifyParameterGroupRequest) (response *ModifyParameterGroupResponse, err error) {
	response = CreateModifyParameterGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyParameterGroupWithChan invokes the r_kvstore.ModifyParameterGroup API asynchronously
func (client *Client) ModifyParameterGroupWithChan(request *ModifyParameterGroupRequest) (<-chan *ModifyParameterGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyParameterGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyParameterGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyParameterGroupWithCallback invokes the r_kvstore.ModifyParameterGroup API asynchronously
func (client *Client) ModifyParameterGroupWithCallback(request *ModifyParameterGroupRequest, callback func(response *ModifyParameterGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyParameterGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyParameterGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyParameterGroupRequest is the request struct for api ModifyParameterGroup
type ModifyParameterGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ParameterGroupId     string           `position:"Query" name:"ParameterGroupId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Category             string           `position:"Query" name:"Category"`
	ParameterGroupName   string           `position:"Query" name:"ParameterGroupName"`
	Parameters           string           `position:"Query" name:"Parameters"`
	ParameterGroupDesc   string           `position:"Query" name:"ParameterGroupDesc"`
}

// ModifyParameterGroupResponse is the response struct for api ModifyParameterGroup
type ModifyParameterGroupResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ParamGroupId string `json:"ParamGroupId" xml:"ParamGroupId"`
}

// CreateModifyParameterGroupRequest creates a request to invoke ModifyParameterGroup API
func CreateModifyParameterGroupRequest() (request *ModifyParameterGroupRequest) {
	request = &ModifyParameterGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyParameterGroup", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyParameterGroupResponse creates a response to parse from ModifyParameterGroup response
func CreateModifyParameterGroupResponse() (response *ModifyParameterGroupResponse) {
	response = &ModifyParameterGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
