package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterMemberInfo invokes the r_kvstore.DescribeClusterMemberInfo API synchronously
func (client *Client) DescribeClusterMemberInfo(request *DescribeClusterMemberInfoRequest) (response *DescribeClusterMemberInfoResponse, err error) {
	response = CreateDescribeClusterMemberInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterMemberInfoWithChan invokes the r_kvstore.DescribeClusterMemberInfo API asynchronously
func (client *Client) DescribeClusterMemberInfoWithChan(request *DescribeClusterMemberInfoRequest) (<-chan *DescribeClusterMemberInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterMemberInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterMemberInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterMemberInfoWithCallback invokes the r_kvstore.DescribeClusterMemberInfo API asynchronously
func (client *Client) DescribeClusterMemberInfoWithCallback(request *DescribeClusterMemberInfoRequest, callback func(response *DescribeClusterMemberInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterMemberInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterMemberInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterMemberInfoRequest is the request struct for api DescribeClusterMemberInfo
type DescribeClusterMemberInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	NeedReplica          string           `position:"Query" name:"NeedReplica"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	FilterService        string           `position:"Query" name:"FilterService"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// DescribeClusterMemberInfoResponse is the response struct for api DescribeClusterMemberInfo
type DescribeClusterMemberInfoResponse struct {
	*responses.BaseResponse
	RequestId       string     `json:"RequestId" xml:"RequestId"`
	PageNumber      int        `json:"PageNumber" xml:"PageNumber"`
	PageSize        int        `json:"PageSize" xml:"PageSize"`
	TotalCount      int        `json:"TotalCount" xml:"TotalCount"`
	ClusterChildren []Children `json:"ClusterChildren" xml:"ClusterChildren"`
}

// CreateDescribeClusterMemberInfoRequest creates a request to invoke DescribeClusterMemberInfo API
func CreateDescribeClusterMemberInfoRequest() (request *DescribeClusterMemberInfoRequest) {
	request = &DescribeClusterMemberInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeClusterMemberInfo", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClusterMemberInfoResponse creates a response to parse from DescribeClusterMemberInfo response
func CreateDescribeClusterMemberInfoResponse() (response *DescribeClusterMemberInfoResponse) {
	response = &DescribeClusterMemberInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
