package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveFavorites invokes the quickbi_public.SaveFavorites API synchronously
func (client *Client) SaveFavorites(request *SaveFavoritesRequest) (response *SaveFavoritesResponse, err error) {
	response = CreateSaveFavoritesResponse()
	err = client.DoAction(request, response)
	return
}

// SaveFavoritesWithChan invokes the quickbi_public.SaveFavorites API asynchronously
func (client *Client) SaveFavoritesWithChan(request *SaveFavoritesRequest) (<-chan *SaveFavoritesResponse, <-chan error) {
	responseChan := make(chan *SaveFavoritesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveFavorites(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveFavoritesWithCallback invokes the quickbi_public.SaveFavorites API asynchronously
func (client *Client) SaveFavoritesWithCallback(request *SaveFavoritesRequest, callback func(response *SaveFavoritesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveFavoritesResponse
		var err error
		defer close(result)
		response, err = client.SaveFavorites(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveFavoritesRequest is the request struct for api SaveFavorites
type SaveFavoritesRequest struct {
	*requests.RpcRequest
	WorksType   string `position:"Query" name:"WorksType"`
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	UserId      string `position:"Query" name:"UserId"`
	WorksId     string `position:"Query" name:"WorksId"`
}

// SaveFavoritesResponse is the response struct for api SaveFavorites
type SaveFavoritesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSaveFavoritesRequest creates a request to invoke SaveFavorites API
func CreateSaveFavoritesRequest() (request *SaveFavoritesRequest) {
	request = &SaveFavoritesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "SaveFavorites", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSaveFavoritesResponse creates a response to parse from SaveFavorites response
func CreateSaveFavoritesResponse() (response *SaveFavoritesResponse) {
	response = &SaveFavoritesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
