package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryReadableResourcesListByUserId invokes the quickbi_public.QueryReadableResourcesListByUserId API synchronously
func (client *Client) QueryReadableResourcesListByUserId(request *QueryReadableResourcesListByUserIdRequest) (response *QueryReadableResourcesListByUserIdResponse, err error) {
	response = CreateQueryReadableResourcesListByUserIdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryReadableResourcesListByUserIdWithChan invokes the quickbi_public.QueryReadableResourcesListByUserId API asynchronously
func (client *Client) QueryReadableResourcesListByUserIdWithChan(request *QueryReadableResourcesListByUserIdRequest) (<-chan *QueryReadableResourcesListByUserIdResponse, <-chan error) {
	responseChan := make(chan *QueryReadableResourcesListByUserIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryReadableResourcesListByUserId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryReadableResourcesListByUserIdWithCallback invokes the quickbi_public.QueryReadableResourcesListByUserId API asynchronously
func (client *Client) QueryReadableResourcesListByUserIdWithCallback(request *QueryReadableResourcesListByUserIdRequest, callback func(response *QueryReadableResourcesListByUserIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryReadableResourcesListByUserIdResponse
		var err error
		defer close(result)
		response, err = client.QueryReadableResourcesListByUserId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryReadableResourcesListByUserIdRequest is the request struct for api QueryReadableResourcesListByUserId
type QueryReadableResourcesListByUserIdRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	UserId      string `position:"Query" name:"UserId"`
}

// QueryReadableResourcesListByUserIdResponse is the response struct for api QueryReadableResourcesListByUserId
type QueryReadableResourcesListByUserIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    []Data `json:"Result" xml:"Result"`
}

// CreateQueryReadableResourcesListByUserIdRequest creates a request to invoke QueryReadableResourcesListByUserId API
func CreateQueryReadableResourcesListByUserIdRequest() (request *QueryReadableResourcesListByUserIdRequest) {
	request = &QueryReadableResourcesListByUserIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryReadableResourcesListByUserId", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryReadableResourcesListByUserIdResponse creates a response to parse from QueryReadableResourcesListByUserId response
func CreateQueryReadableResourcesListByUserIdResponse() (response *QueryReadableResourcesListByUserIdResponse) {
	response = &QueryReadableResourcesListByUserIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
