package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCopilotEmbedConfig invokes the quickbi_public.QueryCopilotEmbedConfig API synchronously
func (client *Client) QueryCopilotEmbedConfig(request *QueryCopilotEmbedConfigRequest) (response *QueryCopilotEmbedConfigResponse, err error) {
	response = CreateQueryCopilotEmbedConfigResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCopilotEmbedConfigWithChan invokes the quickbi_public.QueryCopilotEmbedConfig API asynchronously
func (client *Client) QueryCopilotEmbedConfigWithChan(request *QueryCopilotEmbedConfigRequest) (<-chan *QueryCopilotEmbedConfigResponse, <-chan error) {
	responseChan := make(chan *QueryCopilotEmbedConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCopilotEmbedConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCopilotEmbedConfigWithCallback invokes the quickbi_public.QueryCopilotEmbedConfig API asynchronously
func (client *Client) QueryCopilotEmbedConfigWithCallback(request *QueryCopilotEmbedConfigRequest, callback func(response *QueryCopilotEmbedConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCopilotEmbedConfigResponse
		var err error
		defer close(result)
		response, err = client.QueryCopilotEmbedConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCopilotEmbedConfigRequest is the request struct for api QueryCopilotEmbedConfig
type QueryCopilotEmbedConfigRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	Keyword     string `position:"Query" name:"Keyword"`
}

// QueryCopilotEmbedConfigResponse is the response struct for api QueryCopilotEmbedConfig
type QueryCopilotEmbedConfigResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateQueryCopilotEmbedConfigRequest creates a request to invoke QueryCopilotEmbedConfig API
func CreateQueryCopilotEmbedConfigRequest() (request *QueryCopilotEmbedConfigRequest) {
	request = &QueryCopilotEmbedConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryCopilotEmbedConfig", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryCopilotEmbedConfigResponse creates a response to parse from QueryCopilotEmbedConfig response
func CreateQueryCopilotEmbedConfigResponse() (response *QueryCopilotEmbedConfigResponse) {
	response = &QueryCopilotEmbedConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
