package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDataLevelRuleConfig invokes the quickbi_public.DeleteDataLevelRuleConfig API synchronously
func (client *Client) DeleteDataLevelRuleConfig(request *DeleteDataLevelRuleConfigRequest) (response *DeleteDataLevelRuleConfigResponse, err error) {
	response = CreateDeleteDataLevelRuleConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDataLevelRuleConfigWithChan invokes the quickbi_public.DeleteDataLevelRuleConfig API asynchronously
func (client *Client) DeleteDataLevelRuleConfigWithChan(request *DeleteDataLevelRuleConfigRequest) (<-chan *DeleteDataLevelRuleConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteDataLevelRuleConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDataLevelRuleConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDataLevelRuleConfigWithCallback invokes the quickbi_public.DeleteDataLevelRuleConfig API asynchronously
func (client *Client) DeleteDataLevelRuleConfigWithCallback(request *DeleteDataLevelRuleConfigRequest, callback func(response *DeleteDataLevelRuleConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDataLevelRuleConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteDataLevelRuleConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDataLevelRuleConfigRequest is the request struct for api DeleteDataLevelRuleConfig
type DeleteDataLevelRuleConfigRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	RuleId      string `position:"Query" name:"RuleId"`
	CubeId      string `position:"Query" name:"CubeId"`
}

// DeleteDataLevelRuleConfigResponse is the response struct for api DeleteDataLevelRuleConfig
type DeleteDataLevelRuleConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteDataLevelRuleConfigRequest creates a request to invoke DeleteDataLevelRuleConfig API
func CreateDeleteDataLevelRuleConfigRequest() (request *DeleteDataLevelRuleConfigRequest) {
	request = &DeleteDataLevelRuleConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "DeleteDataLevelRuleConfig", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDataLevelRuleConfigResponse creates a response to parse from DeleteDataLevelRuleConfig response
func CreateDeleteDataLevelRuleConfigResponse() (response *DeleteDataLevelRuleConfigResponse) {
	response = &DeleteDataLevelRuleConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
