package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchSubmitReviewInfo invokes the qualitycheck.BatchSubmitReviewInfo API synchronously
func (client *Client) BatchSubmitReviewInfo(request *BatchSubmitReviewInfoRequest) (response *BatchSubmitReviewInfoResponse, err error) {
	response = CreateBatchSubmitReviewInfoResponse()
	err = client.DoAction(request, response)
	return
}

// BatchSubmitReviewInfoWithChan invokes the qualitycheck.BatchSubmitReviewInfo API asynchronously
func (client *Client) BatchSubmitReviewInfoWithChan(request *BatchSubmitReviewInfoRequest) (<-chan *BatchSubmitReviewInfoResponse, <-chan error) {
	responseChan := make(chan *BatchSubmitReviewInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchSubmitReviewInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchSubmitReviewInfoWithCallback invokes the qualitycheck.BatchSubmitReviewInfo API asynchronously
func (client *Client) BatchSubmitReviewInfoWithCallback(request *BatchSubmitReviewInfoRequest, callback func(response *BatchSubmitReviewInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchSubmitReviewInfoResponse
		var err error
		defer close(result)
		response, err = client.BatchSubmitReviewInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchSubmitReviewInfoRequest is the request struct for api BatchSubmitReviewInfo
type BatchSubmitReviewInfoRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// BatchSubmitReviewInfoResponse is the response struct for api BatchSubmitReviewInfo
type BatchSubmitReviewInfoResponse struct {
	*responses.BaseResponse
	RequestId      string                          `json:"RequestId" xml:"RequestId"`
	Success        bool                            `json:"Success" xml:"Success"`
	Code           string                          `json:"Code" xml:"Code"`
	Message        string                          `json:"Message" xml:"Message"`
	HttpStatusCode int                             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInBatchSubmitReviewInfo `json:"Messages" xml:"Messages"`
}

// CreateBatchSubmitReviewInfoRequest creates a request to invoke BatchSubmitReviewInfo API
func CreateBatchSubmitReviewInfoRequest() (request *BatchSubmitReviewInfoRequest) {
	request = &BatchSubmitReviewInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "BatchSubmitReviewInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchSubmitReviewInfoResponse creates a response to parse from BatchSubmitReviewInfo response
func CreateBatchSubmitReviewInfoResponse() (response *BatchSubmitReviewInfoResponse) {
	response = &BatchSubmitReviewInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
