package push

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Push invokes the push.Push API synchronously
func (client *Client) Push(request *PushRequest) (response *PushResponse, err error) {
	response = CreatePushResponse()
	err = client.DoAction(request, response)
	return
}

// PushWithChan invokes the push.Push API asynchronously
func (client *Client) PushWithChan(request *PushRequest) (<-chan *PushResponse, <-chan error) {
	responseChan := make(chan *PushResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Push(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushWithCallback invokes the push.Push API asynchronously
func (client *Client) PushWithCallback(request *PushRequest, callback func(response *PushResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushResponse
		var err error
		defer close(result)
		response, err = client.Push(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushRequest is the request struct for api Push
type PushRequest struct {
	*requests.RpcRequest
	AndroidNotificationBarType       requests.Integer `position:"Query" name:"AndroidNotificationBarType"`
	AndroidMessageOppoNotifyLevel    requests.Integer `position:"Query" name:"AndroidMessageOppoNotifyLevel"`
	DeviceType                       string           `position:"Query" name:"DeviceType"`
	PushTime                         string           `position:"Query" name:"PushTime"`
	SendSpeed                        requests.Integer `position:"Query" name:"SendSpeed"`
	IOSRemindBody                    string           `position:"Query" name:"iOSRemindBody"`
	Trim                             requests.Boolean `position:"Query" name:"Trim"`
	AndroidPopupTitle                string           `position:"Query" name:"AndroidPopupTitle"`
	IOSApnsEnv                       string           `position:"Query" name:"iOSApnsEnv"`
	AndroidNotificationBarPriority   requests.Integer `position:"Query" name:"AndroidNotificationBarPriority"`
	ExpireTime                       string           `position:"Query" name:"ExpireTime"`
	AndroidImageUrl                  string           `position:"Query" name:"AndroidImageUrl"`
	AndroidVivoReceiptId             string           `position:"Query" name:"AndroidVivoReceiptId"`
	IOSNotificationCategory          string           `position:"Query" name:"iOSNotificationCategory"`
	AndroidXiaomiBigPictureUrl       string           `position:"Query" name:"AndroidXiaomiBigPictureUrl"`
	HarmonyCategory                  string           `position:"Query" name:"HarmonyCategory"`
	IOSRemind                        requests.Boolean `position:"Query" name:"iOSRemind"`
	IOSNotificationThreadId          string           `position:"Query" name:"iOSNotificationThreadId"`
	AndroidHuaweiTargetUserType      requests.Integer `position:"Query" name:"AndroidHuaweiTargetUserType"`
	AndroidMessageHuaweiUrgency      string           `position:"Query" name:"AndroidMessageHuaweiUrgency"`
	IOSInterruptionLevel             string           `position:"Query" name:"iOSInterruptionLevel"`
	AndroidExtParameters             string           `position:"Query" name:"AndroidExtParameters"`
	IOSBadge                         requests.Integer `position:"Query" name:"iOSBadge"`
	IOSBadgeAutoIncrement            requests.Boolean `position:"Query" name:"iOSBadgeAutoIncrement"`
	AndroidOpenType                  string           `position:"Query" name:"AndroidOpenType"`
	HarmonyRemindTitle               string           `position:"Query" name:"HarmonyRemindTitle"`
	AndroidBadgeClass                string           `position:"Query" name:"AndroidBadgeClass"`
	SmsDelaySecs                     requests.Integer `position:"Query" name:"SmsDelaySecs"`
	AndroidRenderStyle               requests.Integer `position:"Query" name:"AndroidRenderStyle"`
	IOSExtParameters                 string           `position:"Query" name:"iOSExtParameters"`
	AndroidXiaomiImageUrl            string           `position:"Query" name:"AndroidXiaomiImageUrl"`
	HarmonyUri                       string           `position:"Query" name:"HarmonyUri"`
	SmsTemplateName                  string           `position:"Query" name:"SmsTemplateName"`
	HarmonyExtParameters             string           `position:"Query" name:"HarmonyExtParameters"`
	AndroidBigPictureUrl             string           `position:"Query" name:"AndroidBigPictureUrl"`
	IOSSilentNotification            requests.Boolean `position:"Query" name:"iOSSilentNotification"`
	HarmonyNotificationSlotType      string           `position:"Query" name:"HarmonyNotificationSlotType"`
	AndroidBigTitle                  string           `position:"Query" name:"AndroidBigTitle"`
	AndroidNotificationChannel       string           `position:"Query" name:"AndroidNotificationChannel"`
	AndroidRemind                    requests.Boolean `position:"Query" name:"AndroidRemind"`
	AndroidActivity                  string           `position:"Query" name:"AndroidActivity"`
	SmsSignName                      string           `position:"Query" name:"SmsSignName"`
	AndroidNotificationNotifyId      requests.Integer `position:"Query" name:"AndroidNotificationNotifyId"`
	AppKey                           requests.Integer `position:"Query" name:"AppKey"`
	TargetValue                      string           `position:"Query" name:"TargetValue"`
	HarmonyBadgeSetNum               requests.Integer `position:"Query" name:"HarmonyBadgeSetNum"`
	AndroidXiaoMiNotifyTitle         string           `position:"Query" name:"AndroidXiaoMiNotifyTitle"`
	SmsSendPolicy                    requests.Integer `position:"Query" name:"SmsSendPolicy"`
	Body                             string           `position:"Query" name:"Body"`
	AndroidNotificationHuaweiChannel string           `position:"Query" name:"AndroidNotificationHuaweiChannel"`
	AndroidPopupActivity             string           `position:"Query" name:"AndroidPopupActivity"`
	HarmonyNotifyId                  requests.Integer `position:"Query" name:"HarmonyNotifyId"`
	HarmonyRenderStyle               string           `position:"Query" name:"HarmonyRenderStyle"`
	AndroidMessageVivoCategory       string           `position:"Query" name:"AndroidMessageVivoCategory"`
	AndroidNotifyType                string           `position:"Query" name:"AndroidNotifyType"`
	AndroidMessageHuaweiCategory     string           `position:"Query" name:"AndroidMessageHuaweiCategory"`
	IOSMusic                         string           `position:"Query" name:"iOSMusic"`
	IOSMutableContent                requests.Boolean `position:"Query" name:"iOSMutableContent"`
	AndroidNotificationThreadId      string           `position:"Query" name:"AndroidNotificationThreadId"`
	AndroidHonorTargetUserType       requests.Integer `position:"Query" name:"AndroidHonorTargetUserType"`
	HarmonyRemindBody                string           `position:"Query" name:"HarmonyRemindBody"`
	AndroidNotificationVivoChannel   string           `position:"Query" name:"AndroidNotificationVivoChannel"`
	AndroidNotificationXiaomiChannel string           `position:"Query" name:"AndroidNotificationXiaomiChannel"`
	HarmonyAction                    string           `position:"Query" name:"HarmonyAction"`
	StoreOffline                     requests.Boolean `position:"Query" name:"StoreOffline"`
	IOSRelevanceScore                string           `position:"Query" name:"iOSRelevanceScore"`
	SmsParams                        string           `position:"Query" name:"SmsParams"`
	AndroidVivoPushMode              requests.Integer `position:"Query" name:"AndroidVivoPushMode"`
	AndroidInboxBody                 string           `position:"Query" name:"AndroidInboxBody"`
	JobKey                           string           `position:"Query" name:"JobKey"`
	HarmonyReceiptId                 string           `position:"Query" name:"HarmonyReceiptId"`
	AndroidOpenUrl                   string           `position:"Query" name:"AndroidOpenUrl"`
	AndroidBadgeSetNum               requests.Integer `position:"Query" name:"AndroidBadgeSetNum"`
	AndroidXiaoMiNotifyBody          string           `position:"Query" name:"AndroidXiaoMiNotifyBody"`
	IOSSubtitle                      string           `position:"Query" name:"iOSSubtitle"`
	HarmonyRemind                    requests.Boolean `position:"Query" name:"HarmonyRemind"`
	AndroidMusic                     string           `position:"Query" name:"AndroidMusic"`
	HarmonyExtensionPush             requests.Boolean `position:"Query" name:"HarmonyExtensionPush"`
	IOSNotificationCollapseId        string           `position:"Query" name:"iOSNotificationCollapseId"`
	PushType                         string           `position:"Query" name:"PushType"`
	HarmonyExtensionExtraData        string           `position:"Query" name:"HarmonyExtensionExtraData"`
	HarmonyImageUrl                  string           `position:"Query" name:"HarmonyImageUrl"`
	AndroidBigBody                   string           `position:"Query" name:"AndroidBigBody"`
	Title                            string           `position:"Query" name:"Title"`
	HarmonyBadgeAddNum               requests.Integer `position:"Query" name:"HarmonyBadgeAddNum"`
	HarmonyTestMessage               requests.Boolean `position:"Query" name:"HarmonyTestMessage"`
	AndroidBadgeAddNum               requests.Integer `position:"Query" name:"AndroidBadgeAddNum"`
	AndroidHuaweiReceiptId           string           `position:"Query" name:"AndroidHuaweiReceiptId"`
	AndroidNotificationHonorChannel  string           `position:"Query" name:"AndroidNotificationHonorChannel"`
	AndroidTargetUserType            requests.Integer `position:"Query" name:"AndroidTargetUserType"`
	AndroidPopupBody                 string           `position:"Query" name:"AndroidPopupBody"`
	AndroidNotificationGroup         string           `position:"Query" name:"AndroidNotificationGroup"`
	SendChannels                     string           `position:"Query" name:"SendChannels"`
	HarmonyActionType                string           `position:"Query" name:"HarmonyActionType"`
	Target                           string           `position:"Query" name:"Target"`
	HarmonyInboxContent              string           `position:"Query" name:"HarmonyInboxContent"`
	AndroidMessageOppoCategory       string           `position:"Query" name:"AndroidMessageOppoCategory"`
	AndroidXiaoMiActivity            string           `position:"Query" name:"AndroidXiaoMiActivity"`
}

// PushResponse is the response struct for api Push
type PushResponse struct {
	*responses.BaseResponse
	MessageId string `json:"MessageId" xml:"MessageId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePushRequest creates a request to invoke Push API
func CreatePushRequest() (request *PushRequest) {
	request = &PushRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Push", "2016-08-01", "Push", "", "")
	request.Method = requests.POST
	return
}

// CreatePushResponse creates a response to parse from Push response
func CreatePushResponse() (response *PushResponse) {
	response = &PushResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
