package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyActiveOperationMaintainConf invokes the polardbx.ModifyActiveOperationMaintainConf API synchronously
func (client *Client) ModifyActiveOperationMaintainConf(request *ModifyActiveOperationMaintainConfRequest) (response *ModifyActiveOperationMaintainConfResponse, err error) {
	response = CreateModifyActiveOperationMaintainConfResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyActiveOperationMaintainConfWithChan invokes the polardbx.ModifyActiveOperationMaintainConf API asynchronously
func (client *Client) ModifyActiveOperationMaintainConfWithChan(request *ModifyActiveOperationMaintainConfRequest) (<-chan *ModifyActiveOperationMaintainConfResponse, <-chan error) {
	responseChan := make(chan *ModifyActiveOperationMaintainConfResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyActiveOperationMaintainConf(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyActiveOperationMaintainConfWithCallback invokes the polardbx.ModifyActiveOperationMaintainConf API asynchronously
func (client *Client) ModifyActiveOperationMaintainConfWithCallback(request *ModifyActiveOperationMaintainConfRequest, callback func(response *ModifyActiveOperationMaintainConfResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyActiveOperationMaintainConfResponse
		var err error
		defer close(result)
		response, err = client.ModifyActiveOperationMaintainConf(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyActiveOperationMaintainConfRequest is the request struct for api ModifyActiveOperationMaintainConf
type ModifyActiveOperationMaintainConfRequest struct {
	*requests.RpcRequest
	CycleTime         string           `position:"Query" name:"CycleTime"`
	MaintainStartTime string           `position:"Query" name:"MaintainStartTime"`
	CycleType         string           `position:"Query" name:"CycleType"`
	MaintainEndTime   string           `position:"Query" name:"MaintainEndTime"`
	Status            requests.Integer `position:"Query" name:"Status"`
}

// ModifyActiveOperationMaintainConfResponse is the response struct for api ModifyActiveOperationMaintainConf
type ModifyActiveOperationMaintainConfResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyActiveOperationMaintainConfRequest creates a request to invoke ModifyActiveOperationMaintainConf API
func CreateModifyActiveOperationMaintainConfRequest() (request *ModifyActiveOperationMaintainConfRequest) {
	request = &ModifyActiveOperationMaintainConfRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "ModifyActiveOperationMaintainConf", "polardbx", "openAPI")
	request.Method = requests.GET
	return
}

// CreateModifyActiveOperationMaintainConfResponse creates a response to parse from ModifyActiveOperationMaintainConf response
func CreateModifyActiveOperationMaintainConfResponse() (response *ModifyActiveOperationMaintainConfResponse) {
	response = &ModifyActiveOperationMaintainConfResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
