package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstanceResources invokes the pairecservice.ListInstanceResources API synchronously
func (client *Client) ListInstanceResources(request *ListInstanceResourcesRequest) (response *ListInstanceResourcesResponse, err error) {
	response = CreateListInstanceResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstanceResourcesWithChan invokes the pairecservice.ListInstanceResources API asynchronously
func (client *Client) ListInstanceResourcesWithChan(request *ListInstanceResourcesRequest) (<-chan *ListInstanceResourcesResponse, <-chan error) {
	responseChan := make(chan *ListInstanceResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstanceResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstanceResourcesWithCallback invokes the pairecservice.ListInstanceResources API asynchronously
func (client *Client) ListInstanceResourcesWithCallback(request *ListInstanceResourcesRequest, callback func(response *ListInstanceResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstanceResourcesResponse
		var err error
		defer close(result)
		response, err = client.ListInstanceResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstanceResourcesRequest is the request struct for api ListInstanceResources
type ListInstanceResourcesRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Category   string `position:"Query" name:"Category"`
	Type       string `position:"Query" name:"Type"`
	Group      string `position:"Query" name:"Group"`
}

// ListInstanceResourcesResponse is the response struct for api ListInstanceResources
type ListInstanceResourcesResponse struct {
	*responses.BaseResponse
	RequestId  string          `json:"RequestId" xml:"RequestId"`
	TotalCount int64           `json:"TotalCount" xml:"TotalCount"`
	Resources  []ResourcesItem `json:"Resources" xml:"Resources"`
}

// CreateListInstanceResourcesRequest creates a request to invoke ListInstanceResources API
func CreateListInstanceResourcesRequest() (request *ListInstanceResourcesRequest) {
	request = &ListInstanceResourcesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListInstanceResources", "/api/v1/instances/[InstanceId]/resources", "", "")
	request.Method = requests.GET
	return
}

// CreateListInstanceResourcesResponse creates a response to parse from ListInstanceResources response
func CreateListInstanceResourcesResponse() (response *ListInstanceResourcesResponse) {
	response = &ListInstanceResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
