package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateTrafficControlTaskConfig invokes the pairecservice.GenerateTrafficControlTaskConfig API synchronously
func (client *Client) GenerateTrafficControlTaskConfig(request *GenerateTrafficControlTaskConfigRequest) (response *GenerateTrafficControlTaskConfigResponse, err error) {
	response = CreateGenerateTrafficControlTaskConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateTrafficControlTaskConfigWithChan invokes the pairecservice.GenerateTrafficControlTaskConfig API asynchronously
func (client *Client) GenerateTrafficControlTaskConfigWithChan(request *GenerateTrafficControlTaskConfigRequest) (<-chan *GenerateTrafficControlTaskConfigResponse, <-chan error) {
	responseChan := make(chan *GenerateTrafficControlTaskConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateTrafficControlTaskConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateTrafficControlTaskConfigWithCallback invokes the pairecservice.GenerateTrafficControlTaskConfig API asynchronously
func (client *Client) GenerateTrafficControlTaskConfigWithCallback(request *GenerateTrafficControlTaskConfigRequest, callback func(response *GenerateTrafficControlTaskConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateTrafficControlTaskConfigResponse
		var err error
		defer close(result)
		response, err = client.GenerateTrafficControlTaskConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateTrafficControlTaskConfigRequest is the request struct for api GenerateTrafficControlTaskConfig
type GenerateTrafficControlTaskConfigRequest struct {
	*requests.RoaRequest
	TrafficControlTaskId string `position:"Path" name:"TrafficControlTaskId"`
	Body                 string `position:"Body" name:"body"`
}

// GenerateTrafficControlTaskConfigResponse is the response struct for api GenerateTrafficControlTaskConfig
type GenerateTrafficControlTaskConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Config    string `json:"Config" xml:"Config"`
}

// CreateGenerateTrafficControlTaskConfigRequest creates a request to invoke GenerateTrafficControlTaskConfig API
func CreateGenerateTrafficControlTaskConfigRequest() (request *GenerateTrafficControlTaskConfigRequest) {
	request = &GenerateTrafficControlTaskConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GenerateTrafficControlTaskConfig", "/api/v1/trafficcontroltasks/[TrafficControlTaskId]/action/generateconfig", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateTrafficControlTaskConfigResponse creates a response to parse from GenerateTrafficControlTaskConfig response
func CreateGenerateTrafficControlTaskConfigResponse() (response *GenerateTrafficControlTaskConfigResponse) {
	response = &GenerateTrafficControlTaskConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
