package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateParam invokes the pairecservice.CreateParam API synchronously
func (client *Client) CreateParam(request *CreateParamRequest) (response *CreateParamResponse, err error) {
	response = CreateCreateParamResponse()
	err = client.DoAction(request, response)
	return
}

// CreateParamWithChan invokes the pairecservice.CreateParam API asynchronously
func (client *Client) CreateParamWithChan(request *CreateParamRequest) (<-chan *CreateParamResponse, <-chan error) {
	responseChan := make(chan *CreateParamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateParam(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateParamWithCallback invokes the pairecservice.CreateParam API asynchronously
func (client *Client) CreateParamWithCallback(request *CreateParamRequest, callback func(response *CreateParamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateParamResponse
		var err error
		defer close(result)
		response, err = client.CreateParam(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateParamRequest is the request struct for api CreateParam
type CreateParamRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateParamResponse is the response struct for api CreateParam
type CreateParamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ParamId   int64  `json:"ParamId" xml:"ParamId"`
}

// CreateCreateParamRequest creates a request to invoke CreateParam API
func CreateCreateParamRequest() (request *CreateParamRequest) {
	request = &CreateParamRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateParam", "/api/v1/params", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateParamResponse creates a response to parse from CreateParam response
func CreateCreateParamResponse() (response *CreateParamResponse) {
	response = &CreateParamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
