package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloneExperimentGroup invokes the pairecservice.CloneExperimentGroup API synchronously
func (client *Client) CloneExperimentGroup(request *CloneExperimentGroupRequest) (response *CloneExperimentGroupResponse, err error) {
	response = CreateCloneExperimentGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CloneExperimentGroupWithChan invokes the pairecservice.CloneExperimentGroup API asynchronously
func (client *Client) CloneExperimentGroupWithChan(request *CloneExperimentGroupRequest) (<-chan *CloneExperimentGroupResponse, <-chan error) {
	responseChan := make(chan *CloneExperimentGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloneExperimentGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloneExperimentGroupWithCallback invokes the pairecservice.CloneExperimentGroup API asynchronously
func (client *Client) CloneExperimentGroupWithCallback(request *CloneExperimentGroupRequest, callback func(response *CloneExperimentGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloneExperimentGroupResponse
		var err error
		defer close(result)
		response, err = client.CloneExperimentGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloneExperimentGroupRequest is the request struct for api CloneExperimentGroup
type CloneExperimentGroupRequest struct {
	*requests.RoaRequest
	Body              string `position:"Body" name:"body"`
	ExperimentGroupId string `position:"Path" name:"ExperimentGroupId"`
}

// CloneExperimentGroupResponse is the response struct for api CloneExperimentGroup
type CloneExperimentGroupResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	ExperimentGroupId string `json:"ExperimentGroupId" xml:"ExperimentGroupId"`
}

// CreateCloneExperimentGroupRequest creates a request to invoke CloneExperimentGroup API
func CreateCloneExperimentGroupRequest() (request *CloneExperimentGroupRequest) {
	request = &CloneExperimentGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CloneExperimentGroup", "/api/v1/experimentgroups/[ExperimentGroupId]/action/clone", "", "")
	request.Method = requests.POST
	return
}

// CreateCloneExperimentGroupResponse creates a response to parse from CloneExperimentGroup response
func CreateCloneExperimentGroupResponse() (response *CloneExperimentGroupResponse) {
	response = &CloneExperimentGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
