package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFeatureViewFieldRelationships invokes the paifeaturestore.ListFeatureViewFieldRelationships API synchronously
func (client *Client) ListFeatureViewFieldRelationships(request *ListFeatureViewFieldRelationshipsRequest) (response *ListFeatureViewFieldRelationshipsResponse, err error) {
	response = CreateListFeatureViewFieldRelationshipsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFeatureViewFieldRelationshipsWithChan invokes the paifeaturestore.ListFeatureViewFieldRelationships API asynchronously
func (client *Client) ListFeatureViewFieldRelationshipsWithChan(request *ListFeatureViewFieldRelationshipsRequest) (<-chan *ListFeatureViewFieldRelationshipsResponse, <-chan error) {
	responseChan := make(chan *ListFeatureViewFieldRelationshipsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFeatureViewFieldRelationships(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFeatureViewFieldRelationshipsWithCallback invokes the paifeaturestore.ListFeatureViewFieldRelationships API asynchronously
func (client *Client) ListFeatureViewFieldRelationshipsWithCallback(request *ListFeatureViewFieldRelationshipsRequest, callback func(response *ListFeatureViewFieldRelationshipsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFeatureViewFieldRelationshipsResponse
		var err error
		defer close(result)
		response, err = client.ListFeatureViewFieldRelationships(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFeatureViewFieldRelationshipsRequest is the request struct for api ListFeatureViewFieldRelationships
type ListFeatureViewFieldRelationshipsRequest struct {
	*requests.RoaRequest
	FieldName     string `position:"Path" name:"FieldName"`
	InstanceId    string `position:"Path" name:"InstanceId"`
	FeatureViewId string `position:"Path" name:"FeatureViewId"`
}

// ListFeatureViewFieldRelationshipsResponse is the response struct for api ListFeatureViewFieldRelationships
type ListFeatureViewFieldRelationshipsResponse struct {
	*responses.BaseResponse
	RequestId     string              `json:"RequestId" xml:"RequestId"`
	Relationships []RelationshipsItem `json:"Relationships" xml:"Relationships"`
}

// CreateListFeatureViewFieldRelationshipsRequest creates a request to invoke ListFeatureViewFieldRelationships API
func CreateListFeatureViewFieldRelationshipsRequest() (request *ListFeatureViewFieldRelationshipsRequest) {
	request = &ListFeatureViewFieldRelationshipsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "ListFeatureViewFieldRelationships", "/api/v1/instances/[InstanceId]/featureviews/[FeatureViewId]/fields/[FieldName]/relationships", "", "")
	request.Method = requests.GET
	return
}

// CreateListFeatureViewFieldRelationshipsResponse creates a response to parse from ListFeatureViewFieldRelationships response
func CreateListFeatureViewFieldRelationshipsResponse() (response *ListFeatureViewFieldRelationshipsResponse) {
	response = &ListFeatureViewFieldRelationshipsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
