package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDatasourceTables invokes the paifeaturestore.ListDatasourceTables API synchronously
func (client *Client) ListDatasourceTables(request *ListDatasourceTablesRequest) (response *ListDatasourceTablesResponse, err error) {
	response = CreateListDatasourceTablesResponse()
	err = client.DoAction(request, response)
	return
}

// ListDatasourceTablesWithChan invokes the paifeaturestore.ListDatasourceTables API asynchronously
func (client *Client) ListDatasourceTablesWithChan(request *ListDatasourceTablesRequest) (<-chan *ListDatasourceTablesResponse, <-chan error) {
	responseChan := make(chan *ListDatasourceTablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDatasourceTables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDatasourceTablesWithCallback invokes the paifeaturestore.ListDatasourceTables API asynchronously
func (client *Client) ListDatasourceTablesWithCallback(request *ListDatasourceTablesRequest, callback func(response *ListDatasourceTablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDatasourceTablesResponse
		var err error
		defer close(result)
		response, err = client.ListDatasourceTables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDatasourceTablesRequest is the request struct for api ListDatasourceTables
type ListDatasourceTablesRequest struct {
	*requests.RoaRequest
	InstanceId   string `position:"Path" name:"InstanceId"`
	DatasourceId string `position:"Path" name:"DatasourceId"`
	TableName    string `position:"Query" name:"TableName"`
}

// ListDatasourceTablesResponse is the response struct for api ListDatasourceTables
type ListDatasourceTablesResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int64    `json:"TotalCount" xml:"TotalCount"`
	Tables     []string `json:"Tables" xml:"Tables"`
}

// CreateListDatasourceTablesRequest creates a request to invoke ListDatasourceTables API
func CreateListDatasourceTablesRequest() (request *ListDatasourceTablesRequest) {
	request = &ListDatasourceTablesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "ListDatasourceTables", "/api/v1/instances/[InstanceId]/datasources/[DatasourceId]/tables", "", "")
	request.Method = requests.GET
	return
}

// CreateListDatasourceTablesResponse creates a response to parse from ListDatasourceTables response
func CreateListDatasourceTablesResponse() (response *ListDatasourceTablesResponse) {
	response = &ListDatasourceTablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
