package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetModelFeatureFGFeature invokes the paifeaturestore.GetModelFeatureFGFeature API synchronously
func (client *Client) GetModelFeatureFGFeature(request *GetModelFeatureFGFeatureRequest) (response *GetModelFeatureFGFeatureResponse, err error) {
	response = CreateGetModelFeatureFGFeatureResponse()
	err = client.DoAction(request, response)
	return
}

// GetModelFeatureFGFeatureWithChan invokes the paifeaturestore.GetModelFeatureFGFeature API asynchronously
func (client *Client) GetModelFeatureFGFeatureWithChan(request *GetModelFeatureFGFeatureRequest) (<-chan *GetModelFeatureFGFeatureResponse, <-chan error) {
	responseChan := make(chan *GetModelFeatureFGFeatureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetModelFeatureFGFeature(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetModelFeatureFGFeatureWithCallback invokes the paifeaturestore.GetModelFeatureFGFeature API asynchronously
func (client *Client) GetModelFeatureFGFeatureWithCallback(request *GetModelFeatureFGFeatureRequest, callback func(response *GetModelFeatureFGFeatureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetModelFeatureFGFeatureResponse
		var err error
		defer close(result)
		response, err = client.GetModelFeatureFGFeature(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetModelFeatureFGFeatureRequest is the request struct for api GetModelFeatureFGFeature
type GetModelFeatureFGFeatureRequest struct {
	*requests.RoaRequest
	ModelFeatureId string `position:"Path" name:"ModelFeatureId"`
	InstanceId     string `position:"Path" name:"InstanceId"`
}

// GetModelFeatureFGFeatureResponse is the response struct for api GetModelFeatureFGFeature
type GetModelFeatureFGFeatureResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	Reserves         []string               `json:"Reserves" xml:"Reserves"`
	RawFeatures      []RawFeaturesItem      `json:"RawFeatures" xml:"RawFeatures"`
	LookupFeatures   []LookupFeaturesItem   `json:"LookupFeatures" xml:"LookupFeatures"`
	SequenceFeatures []SequenceFeaturesItem `json:"SequenceFeatures" xml:"SequenceFeatures"`
}

// CreateGetModelFeatureFGFeatureRequest creates a request to invoke GetModelFeatureFGFeature API
func CreateGetModelFeatureFGFeatureRequest() (request *GetModelFeatureFGFeatureRequest) {
	request = &GetModelFeatureFGFeatureRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "GetModelFeatureFGFeature", "/api/v1/instances/[InstanceId]/modelfeatures/[ModelFeatureId]/fgfeature", "", "")
	request.Method = requests.GET
	return
}

// CreateGetModelFeatureFGFeatureResponse creates a response to parse from GetModelFeatureFGFeature response
func CreateGetModelFeatureFGFeatureResponse() (response *GetModelFeatureFGFeatureResponse) {
	response = &GetModelFeatureFGFeatureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
