package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFeatureView invokes the paifeaturestore.CreateFeatureView API synchronously
func (client *Client) CreateFeatureView(request *CreateFeatureViewRequest) (response *CreateFeatureViewResponse, err error) {
	response = CreateCreateFeatureViewResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFeatureViewWithChan invokes the paifeaturestore.CreateFeatureView API asynchronously
func (client *Client) CreateFeatureViewWithChan(request *CreateFeatureViewRequest) (<-chan *CreateFeatureViewResponse, <-chan error) {
	responseChan := make(chan *CreateFeatureViewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFeatureView(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFeatureViewWithCallback invokes the paifeaturestore.CreateFeatureView API asynchronously
func (client *Client) CreateFeatureViewWithCallback(request *CreateFeatureViewRequest, callback func(response *CreateFeatureViewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFeatureViewResponse
		var err error
		defer close(result)
		response, err = client.CreateFeatureView(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFeatureViewRequest is the request struct for api CreateFeatureView
type CreateFeatureViewRequest struct {
	*requests.RoaRequest
	Body       string `position:"Body" name:"body"`
	InstanceId string `position:"Path" name:"InstanceId"`
}

// CreateFeatureViewResponse is the response struct for api CreateFeatureView
type CreateFeatureViewResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	FeatureViewId string `json:"FeatureViewId" xml:"FeatureViewId"`
}

// CreateCreateFeatureViewRequest creates a request to invoke CreateFeatureView API
func CreateCreateFeatureViewRequest() (request *CreateFeatureViewRequest) {
	request = &CreateFeatureViewRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "CreateFeatureView", "/api/v1/instances/[InstanceId]/featureviews", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateFeatureViewResponse creates a response to parse from CreateFeatureView response
func CreateCreateFeatureViewResponse() (response *CreateFeatureViewResponse) {
	response = &CreateFeatureViewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
