package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSearchStrategies invokes the opensearch.ListSearchStrategies API synchronously
func (client *Client) ListSearchStrategies(request *ListSearchStrategiesRequest) (response *ListSearchStrategiesResponse, err error) {
	response = CreateListSearchStrategiesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSearchStrategiesWithChan invokes the opensearch.ListSearchStrategies API asynchronously
func (client *Client) ListSearchStrategiesWithChan(request *ListSearchStrategiesRequest) (<-chan *ListSearchStrategiesResponse, <-chan error) {
	responseChan := make(chan *ListSearchStrategiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSearchStrategies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSearchStrategiesWithCallback invokes the opensearch.ListSearchStrategies API asynchronously
func (client *Client) ListSearchStrategiesWithCallback(request *ListSearchStrategiesRequest, callback func(response *ListSearchStrategiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSearchStrategiesResponse
		var err error
		defer close(result)
		response, err = client.ListSearchStrategies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSearchStrategiesRequest is the request struct for api ListSearchStrategies
type ListSearchStrategiesRequest struct {
	*requests.RoaRequest
	AppId            string `position:"Path" name:"appId"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// ListSearchStrategiesResponse is the response struct for api ListSearchStrategies
type ListSearchStrategiesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateListSearchStrategiesRequest creates a request to invoke ListSearchStrategies API
func CreateListSearchStrategiesRequest() (request *ListSearchStrategiesRequest) {
	request = &ListSearchStrategiesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListSearchStrategies", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/search-strategies", "", "")
	request.Method = requests.GET
	return
}

// CreateListSearchStrategiesResponse creates a response to parse from ListSearchStrategies response
func CreateListSearchStrategiesResponse() (response *ListSearchStrategiesResponse) {
	response = &ListSearchStrategiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
