package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInterventionDictionaries invokes the opensearch.ListInterventionDictionaries API synchronously
func (client *Client) ListInterventionDictionaries(request *ListInterventionDictionariesRequest) (response *ListInterventionDictionariesResponse, err error) {
	response = CreateListInterventionDictionariesResponse()
	err = client.DoAction(request, response)
	return
}

// ListInterventionDictionariesWithChan invokes the opensearch.ListInterventionDictionaries API asynchronously
func (client *Client) ListInterventionDictionariesWithChan(request *ListInterventionDictionariesRequest) (<-chan *ListInterventionDictionariesResponse, <-chan error) {
	responseChan := make(chan *ListInterventionDictionariesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInterventionDictionaries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInterventionDictionariesWithCallback invokes the opensearch.ListInterventionDictionaries API asynchronously
func (client *Client) ListInterventionDictionariesWithCallback(request *ListInterventionDictionariesRequest, callback func(response *ListInterventionDictionariesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInterventionDictionariesResponse
		var err error
		defer close(result)
		response, err = client.ListInterventionDictionaries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInterventionDictionariesRequest is the request struct for api ListInterventionDictionaries
type ListInterventionDictionariesRequest struct {
	*requests.RoaRequest
	Types      string           `position:"Query" name:"types"`
	PageSize   requests.Integer `position:"Query" name:"pageSize"`
	PageNumber requests.Integer `position:"Query" name:"pageNumber"`
}

// ListInterventionDictionariesResponse is the response struct for api ListInterventionDictionaries
type ListInterventionDictionariesResponse struct {
	*responses.BaseResponse
	TotalCount int                                        `json:"totalCount" xml:"totalCount"`
	RequestId  string                                     `json:"requestId" xml:"requestId"`
	Result     []ResultItemInListInterventionDictionaries `json:"result" xml:"result"`
}

// CreateListInterventionDictionariesRequest creates a request to invoke ListInterventionDictionaries API
func CreateListInterventionDictionariesRequest() (request *ListInterventionDictionariesRequest) {
	request = &ListInterventionDictionariesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListInterventionDictionaries", "/v4/openapi/intervention-dictionaries", "", "")
	request.Method = requests.GET
	return
}

// CreateListInterventionDictionariesResponse creates a response to parse from ListInterventionDictionaries response
func CreateListInterventionDictionariesResponse() (response *ListInterventionDictionariesResponse) {
	response = &ListInterventionDictionariesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
