package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDomainPart invokes the oms.GetDomainPart API synchronously
func (client *Client) GetDomainPart(request *GetDomainPartRequest) (response *GetDomainPartResponse, err error) {
	response = CreateGetDomainPartResponse()
	err = client.DoAction(request, response)
	return
}

// GetDomainPartWithChan invokes the oms.GetDomainPart API asynchronously
func (client *Client) GetDomainPartWithChan(request *GetDomainPartRequest) (<-chan *GetDomainPartResponse, <-chan error) {
	responseChan := make(chan *GetDomainPartResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDomainPart(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDomainPartWithCallback invokes the oms.GetDomainPart API asynchronously
func (client *Client) GetDomainPartWithCallback(request *GetDomainPartRequest, callback func(response *GetDomainPartResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDomainPartResponse
		var err error
		defer close(result)
		response, err = client.GetDomainPart(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDomainPartRequest is the request struct for api GetDomainPart
type GetDomainPartRequest struct {
	*requests.RpcRequest
	DomainCode     string           `position:"Query" name:"DomainCode"`
	DataType       string           `position:"Query" name:"DataType"`
	CompressEnable requests.Boolean `position:"Query" name:"CompressEnable"`
	Part           string           `position:"Query" name:"Part"`
}

// GetDomainPartResponse is the response struct for api GetDomainPart
type GetDomainPartResponse struct {
	*responses.BaseResponse
	Compressed bool   `json:"Compressed" xml:"Compressed"`
	Data       string `json:"Data" xml:"Data"`
	DataType   string `json:"DataType" xml:"DataType"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainCode string `json:"DomainCode" xml:"DomainCode"`
}

// CreateGetDomainPartRequest creates a request to invoke GetDomainPart API
func CreateGetDomainPartRequest() (request *GetDomainPartRequest) {
	request = &GetDomainPartRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "GetDomainPart", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDomainPartResponse creates a response to parse from GetDomainPart response
func CreateGetDomainPartResponse() (response *GetDomainPartResponse) {
	response = &GetDomainPartResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
