package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSQLHistoryList invokes the oceanbasepro.DescribeSQLHistoryList API synchronously
func (client *Client) DescribeSQLHistoryList(request *DescribeSQLHistoryListRequest) (response *DescribeSQLHistoryListResponse, err error) {
	response = CreateDescribeSQLHistoryListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSQLHistoryListWithChan invokes the oceanbasepro.DescribeSQLHistoryList API asynchronously
func (client *Client) DescribeSQLHistoryListWithChan(request *DescribeSQLHistoryListRequest) (<-chan *DescribeSQLHistoryListResponse, <-chan error) {
	responseChan := make(chan *DescribeSQLHistoryListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSQLHistoryList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSQLHistoryListWithCallback invokes the oceanbasepro.DescribeSQLHistoryList API asynchronously
func (client *Client) DescribeSQLHistoryListWithCallback(request *DescribeSQLHistoryListRequest, callback func(response *DescribeSQLHistoryListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSQLHistoryListResponse
		var err error
		defer close(result)
		response, err = client.DescribeSQLHistoryList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSQLHistoryListRequest is the request struct for api DescribeSQLHistoryList
type DescribeSQLHistoryListRequest struct {
	*requests.RpcRequest
	SQLId      string           `position:"Body" name:"SQLId"`
	EndTime    string           `position:"Body" name:"EndTime"`
	StartTime  string           `position:"Body" name:"StartTime"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	TenantId   string           `position:"Body" name:"TenantId"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
}

// DescribeSQLHistoryListResponse is the response struct for api DescribeSQLHistoryList
type DescribeSQLHistoryListResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	SQLHistoryList SQLHistoryList `json:"SQLHistoryList" xml:"SQLHistoryList"`
}

// CreateDescribeSQLHistoryListRequest creates a request to invoke DescribeSQLHistoryList API
func CreateDescribeSQLHistoryListRequest() (request *DescribeSQLHistoryListRequest) {
	request = &DescribeSQLHistoryListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeSQLHistoryList", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSQLHistoryListResponse creates a response to parse from DescribeSQLHistoryList response
func CreateDescribeSQLHistoryListResponse() (response *DescribeSQLHistoryListResponse) {
	response = &DescribeSQLHistoryListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
