package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTagValue invokes the oceanbasepro.DeleteTagValue API synchronously
func (client *Client) DeleteTagValue(request *DeleteTagValueRequest) (response *DeleteTagValueResponse, err error) {
	response = CreateDeleteTagValueResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTagValueWithChan invokes the oceanbasepro.DeleteTagValue API asynchronously
func (client *Client) DeleteTagValueWithChan(request *DeleteTagValueRequest) (<-chan *DeleteTagValueResponse, <-chan error) {
	responseChan := make(chan *DeleteTagValueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTagValue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTagValueWithCallback invokes the oceanbasepro.DeleteTagValue API asynchronously
func (client *Client) DeleteTagValueWithCallback(request *DeleteTagValueRequest, callback func(response *DeleteTagValueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTagValueResponse
		var err error
		defer close(result)
		response, err = client.DeleteTagValue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTagValueRequest is the request struct for api DeleteTagValue
type DeleteTagValueRequest struct {
	*requests.RpcRequest
	Value string `position:"Body" name:"Value"`
	Key   string `position:"Body" name:"Key"`
}

// DeleteTagValueResponse is the response struct for api DeleteTagValue
type DeleteTagValueResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTagValueRequest creates a request to invoke DeleteTagValue API
func CreateDeleteTagValueRequest() (request *DeleteTagValueRequest) {
	request = &DeleteTagValueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DeleteTagValue", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTagValueResponse creates a response to parse from DeleteTagValue response
func CreateDeleteTagValueResponse() (response *DeleteTagValueResponse) {
	response = &DeleteTagValueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
