package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTagByGroupId invokes the oam.ListTagByGroupId API synchronously
// api document: https://help.aliyun.com/api/oam/listtagbygroupid.html
func (client *Client) ListTagByGroupId(request *ListTagByGroupIdRequest) (response *ListTagByGroupIdResponse, err error) {
	response = CreateListTagByGroupIdResponse()
	err = client.DoAction(request, response)
	return
}

// ListTagByGroupIdWithChan invokes the oam.ListTagByGroupId API asynchronously
// api document: https://help.aliyun.com/api/oam/listtagbygroupid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListTagByGroupIdWithChan(request *ListTagByGroupIdRequest) (<-chan *ListTagByGroupIdResponse, <-chan error) {
	responseChan := make(chan *ListTagByGroupIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTagByGroupId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTagByGroupIdWithCallback invokes the oam.ListTagByGroupId API asynchronously
// api document: https://help.aliyun.com/api/oam/listtagbygroupid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListTagByGroupIdWithCallback(request *ListTagByGroupIdRequest, callback func(response *ListTagByGroupIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTagByGroupIdResponse
		var err error
		defer close(result)
		response, err = client.ListTagByGroupId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTagByGroupIdRequest is the request struct for api ListTagByGroupId
type ListTagByGroupIdRequest struct {
	*requests.RpcRequest
	Id string `position:"Query" name:"Id"`
}

// ListTagByGroupIdResponse is the response struct for api ListTagByGroupId
type ListTagByGroupIdResponse struct {
	*responses.BaseResponse
	Code      string                 `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Data      DataInListTagByGroupId `json:"Data" xml:"Data"`
}

// CreateListTagByGroupIdRequest creates a request to invoke ListTagByGroupId API
func CreateListTagByGroupIdRequest() (request *ListTagByGroupIdRequest) {
	request = &ListTagByGroupIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "ListTagByGroupId", "", "")
	request.Method = requests.POST
	return
}

// CreateListTagByGroupIdResponse creates a response to parse from ListTagByGroupId response
func CreateListTagByGroupIdResponse() (response *ListTagByGroupIdResponse) {
	response = &ListTagByGroupIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
