package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayIsolationRule invokes the mse.UpdateGatewayIsolationRule API synchronously
func (client *Client) UpdateGatewayIsolationRule(request *UpdateGatewayIsolationRuleRequest) (response *UpdateGatewayIsolationRuleResponse, err error) {
	response = CreateUpdateGatewayIsolationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayIsolationRuleWithChan invokes the mse.UpdateGatewayIsolationRule API asynchronously
func (client *Client) UpdateGatewayIsolationRuleWithChan(request *UpdateGatewayIsolationRuleRequest) (<-chan *UpdateGatewayIsolationRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayIsolationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayIsolationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayIsolationRuleWithCallback invokes the mse.UpdateGatewayIsolationRule API asynchronously
func (client *Client) UpdateGatewayIsolationRuleWithCallback(request *UpdateGatewayIsolationRuleRequest, callback func(response *UpdateGatewayIsolationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayIsolationRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayIsolationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayIsolationRuleRequest is the request struct for api UpdateGatewayIsolationRule
type UpdateGatewayIsolationRuleRequest struct {
	*requests.RpcRequest
	MseSessionId        string           `position:"Query" name:"MseSessionId"`
	BehaviorType        requests.Integer `position:"Query" name:"BehaviorType"`
	Enable              requests.Integer `position:"Query" name:"Enable"`
	Id                  requests.Integer `position:"Query" name:"Id"`
	GatewayId           requests.Integer `position:"Query" name:"GatewayId"`
	ResponseStatusCode  requests.Integer `position:"Query" name:"ResponseStatusCode"`
	RouteId             requests.Integer `position:"Query" name:"RouteId"`
	GatewayUniqueId     string           `position:"Query" name:"GatewayUniqueId"`
	BodyEncoding        requests.Integer `position:"Query" name:"BodyEncoding"`
	ResponseRedirectUrl string           `position:"Query" name:"ResponseRedirectUrl"`
	RouteName           string           `position:"Query" name:"RouteName"`
	AcceptLanguage      string           `position:"Query" name:"AcceptLanguage"`
	MaxConcurrency      requests.Integer `position:"Query" name:"MaxConcurrency"`
	ResponseContentBody string           `position:"Query" name:"ResponseContentBody"`
}

// UpdateGatewayIsolationRuleResponse is the response struct for api UpdateGatewayIsolationRule
type UpdateGatewayIsolationRuleResponse struct {
	*responses.BaseResponse
	RequestId string                           `json:"RequestId" xml:"RequestId"`
	Data      DataInUpdateGatewayIsolationRule `json:"Data" xml:"Data"`
}

// CreateUpdateGatewayIsolationRuleRequest creates a request to invoke UpdateGatewayIsolationRule API
func CreateUpdateGatewayIsolationRuleRequest() (request *UpdateGatewayIsolationRuleRequest) {
	request = &UpdateGatewayIsolationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateGatewayIsolationRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayIsolationRuleResponse creates a response to parse from UpdateGatewayIsolationRule response
func CreateUpdateGatewayIsolationRuleResponse() (response *UpdateGatewayIsolationRuleResponse) {
	response = &UpdateGatewayIsolationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
