package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OrderClusterHealthCheckRiskNotice invokes the mse.OrderClusterHealthCheckRiskNotice API synchronously
func (client *Client) OrderClusterHealthCheckRiskNotice(request *OrderClusterHealthCheckRiskNoticeRequest) (response *OrderClusterHealthCheckRiskNoticeResponse, err error) {
	response = CreateOrderClusterHealthCheckRiskNoticeResponse()
	err = client.DoAction(request, response)
	return
}

// OrderClusterHealthCheckRiskNoticeWithChan invokes the mse.OrderClusterHealthCheckRiskNotice API asynchronously
func (client *Client) OrderClusterHealthCheckRiskNoticeWithChan(request *OrderClusterHealthCheckRiskNoticeRequest) (<-chan *OrderClusterHealthCheckRiskNoticeResponse, <-chan error) {
	responseChan := make(chan *OrderClusterHealthCheckRiskNoticeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OrderClusterHealthCheckRiskNotice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OrderClusterHealthCheckRiskNoticeWithCallback invokes the mse.OrderClusterHealthCheckRiskNotice API asynchronously
func (client *Client) OrderClusterHealthCheckRiskNoticeWithCallback(request *OrderClusterHealthCheckRiskNoticeRequest, callback func(response *OrderClusterHealthCheckRiskNoticeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OrderClusterHealthCheckRiskNoticeResponse
		var err error
		defer close(result)
		response, err = client.OrderClusterHealthCheckRiskNotice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OrderClusterHealthCheckRiskNoticeRequest is the request struct for api OrderClusterHealthCheckRiskNotice
type OrderClusterHealthCheckRiskNoticeRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	RequestPars    string           `position:"Query" name:"RequestPars"`
	Mute           requests.Boolean `position:"Query" name:"Mute"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	NoticeType     string           `position:"Query" name:"NoticeType"`
	RiskCode       string           `position:"Query" name:"RiskCode"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// OrderClusterHealthCheckRiskNoticeResponse is the response struct for api OrderClusterHealthCheckRiskNotice
type OrderClusterHealthCheckRiskNoticeResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateOrderClusterHealthCheckRiskNoticeRequest creates a request to invoke OrderClusterHealthCheckRiskNotice API
func CreateOrderClusterHealthCheckRiskNoticeRequest() (request *OrderClusterHealthCheckRiskNoticeRequest) {
	request = &OrderClusterHealthCheckRiskNoticeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "OrderClusterHealthCheckRiskNotice", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOrderClusterHealthCheckRiskNoticeResponse creates a response to parse from OrderClusterHealthCheckRiskNotice response
func CreateOrderClusterHealthCheckRiskNoticeResponse() (response *OrderClusterHealthCheckRiskNoticeResponse) {
	response = &OrderClusterHealthCheckRiskNoticeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
