package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyGovernanceKubernetesCluster invokes the mse.ModifyGovernanceKubernetesCluster API synchronously
func (client *Client) ModifyGovernanceKubernetesCluster(request *ModifyGovernanceKubernetesClusterRequest) (response *ModifyGovernanceKubernetesClusterResponse, err error) {
	response = CreateModifyGovernanceKubernetesClusterResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyGovernanceKubernetesClusterWithChan invokes the mse.ModifyGovernanceKubernetesCluster API asynchronously
func (client *Client) ModifyGovernanceKubernetesClusterWithChan(request *ModifyGovernanceKubernetesClusterRequest) (<-chan *ModifyGovernanceKubernetesClusterResponse, <-chan error) {
	responseChan := make(chan *ModifyGovernanceKubernetesClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyGovernanceKubernetesCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyGovernanceKubernetesClusterWithCallback invokes the mse.ModifyGovernanceKubernetesCluster API asynchronously
func (client *Client) ModifyGovernanceKubernetesClusterWithCallback(request *ModifyGovernanceKubernetesClusterRequest, callback func(response *ModifyGovernanceKubernetesClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyGovernanceKubernetesClusterResponse
		var err error
		defer close(result)
		response, err = client.ModifyGovernanceKubernetesCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyGovernanceKubernetesClusterRequest is the request struct for api ModifyGovernanceKubernetesCluster
type ModifyGovernanceKubernetesClusterRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	NamespaceInfos string `position:"Body" name:"NamespaceInfos"`
	ClusterId      string `position:"Query" name:"ClusterId"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// ModifyGovernanceKubernetesClusterResponse is the response struct for api ModifyGovernanceKubernetesCluster
type ModifyGovernanceKubernetesClusterResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           bool   `json:"Data" xml:"Data"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateModifyGovernanceKubernetesClusterRequest creates a request to invoke ModifyGovernanceKubernetesCluster API
func CreateModifyGovernanceKubernetesClusterRequest() (request *ModifyGovernanceKubernetesClusterRequest) {
	request = &ModifyGovernanceKubernetesClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ModifyGovernanceKubernetesCluster", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyGovernanceKubernetesClusterResponse creates a response to parse from ModifyGovernanceKubernetesCluster response
func CreateModifyGovernanceKubernetesClusterResponse() (response *ModifyGovernanceKubernetesClusterResponse) {
	response = &ModifyGovernanceKubernetesClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
