package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMPCDUploadInfo invokes the mpaas.QueryMPCDUploadInfo API synchronously
func (client *Client) QueryMPCDUploadInfo(request *QueryMPCDUploadInfoRequest) (response *QueryMPCDUploadInfoResponse, err error) {
	response = CreateQueryMPCDUploadInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMPCDUploadInfoWithChan invokes the mpaas.QueryMPCDUploadInfo API asynchronously
func (client *Client) QueryMPCDUploadInfoWithChan(request *QueryMPCDUploadInfoRequest) (<-chan *QueryMPCDUploadInfoResponse, <-chan error) {
	responseChan := make(chan *QueryMPCDUploadInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMPCDUploadInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMPCDUploadInfoWithCallback invokes the mpaas.QueryMPCDUploadInfo API asynchronously
func (client *Client) QueryMPCDUploadInfoWithCallback(request *QueryMPCDUploadInfoRequest, callback func(response *QueryMPCDUploadInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMPCDUploadInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryMPCDUploadInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMPCDUploadInfoRequest is the request struct for api QueryMPCDUploadInfo
type QueryMPCDUploadInfoRequest struct {
	*requests.RpcRequest
	AppId        string           `position:"Body" name:"AppId"`
	UploadTaskId requests.Integer `position:"Body" name:"UploadTaskId"`
	TenantId     string           `position:"Body" name:"TenantId"`
	WorkspaceId  string           `position:"Body" name:"WorkspaceId"`
}

// QueryMPCDUploadInfoResponse is the response struct for api QueryMPCDUploadInfo
type QueryMPCDUploadInfoResponse struct {
	*responses.BaseResponse
}

// CreateQueryMPCDUploadInfoRequest creates a request to invoke QueryMPCDUploadInfo API
func CreateQueryMPCDUploadInfoRequest() (request *QueryMPCDUploadInfoRequest) {
	request = &QueryMPCDUploadInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "QueryMPCDUploadInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryMPCDUploadInfoResponse creates a response to parse from QueryMPCDUploadInfo response
func CreateQueryMPCDUploadInfoResponse() (response *QueryMPCDUploadInfoResponse) {
	response = &QueryMPCDUploadInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
