package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMsacStageInstanceById invokes the mpaas.DeleteMsacStageInstanceById API synchronously
func (client *Client) DeleteMsacStageInstanceById(request *DeleteMsacStageInstanceByIdRequest) (response *DeleteMsacStageInstanceByIdResponse, err error) {
	response = CreateDeleteMsacStageInstanceByIdResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMsacStageInstanceByIdWithChan invokes the mpaas.DeleteMsacStageInstanceById API asynchronously
func (client *Client) DeleteMsacStageInstanceByIdWithChan(request *DeleteMsacStageInstanceByIdRequest) (<-chan *DeleteMsacStageInstanceByIdResponse, <-chan error) {
	responseChan := make(chan *DeleteMsacStageInstanceByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMsacStageInstanceById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMsacStageInstanceByIdWithCallback invokes the mpaas.DeleteMsacStageInstanceById API asynchronously
func (client *Client) DeleteMsacStageInstanceByIdWithCallback(request *DeleteMsacStageInstanceByIdRequest, callback func(response *DeleteMsacStageInstanceByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMsacStageInstanceByIdResponse
		var err error
		defer close(result)
		response, err = client.DeleteMsacStageInstanceById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMsacStageInstanceByIdRequest is the request struct for api DeleteMsacStageInstanceById
type DeleteMsacStageInstanceByIdRequest struct {
	*requests.RpcRequest
	TenantId                                      string `position:"Body" name:"TenantId"`
	MpaasMappcenterMsacDeleteStageInstanceJsonStr string `position:"Body" name:"MpaasMappcenterMsacDeleteStageInstanceJsonStr"`
	AppId                                         string `position:"Body" name:"AppId"`
	WorkspaceId                                   string `position:"Body" name:"WorkspaceId"`
}

// DeleteMsacStageInstanceByIdResponse is the response struct for api DeleteMsacStageInstanceById
type DeleteMsacStageInstanceByIdResponse struct {
	*responses.BaseResponse
	ResultMessage string                                     `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                     `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                     `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInDeleteMsacStageInstanceById `json:"ResultContent" xml:"ResultContent"`
}

// CreateDeleteMsacStageInstanceByIdRequest creates a request to invoke DeleteMsacStageInstanceById API
func CreateDeleteMsacStageInstanceByIdRequest() (request *DeleteMsacStageInstanceByIdRequest) {
	request = &DeleteMsacStageInstanceByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DeleteMsacStageInstanceById", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMsacStageInstanceByIdResponse creates a response to parse from DeleteMsacStageInstanceById response
func CreateDeleteMsacStageInstanceByIdResponse() (response *DeleteMsacStageInstanceByIdResponse) {
	response = &DeleteMsacStageInstanceByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
