package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOpenGlobalData invokes the mpaas.CreateOpenGlobalData API synchronously
func (client *Client) CreateOpenGlobalData(request *CreateOpenGlobalDataRequest) (response *CreateOpenGlobalDataResponse, err error) {
	response = CreateCreateOpenGlobalDataResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOpenGlobalDataWithChan invokes the mpaas.CreateOpenGlobalData API asynchronously
func (client *Client) CreateOpenGlobalDataWithChan(request *CreateOpenGlobalDataRequest) (<-chan *CreateOpenGlobalDataResponse, <-chan error) {
	responseChan := make(chan *CreateOpenGlobalDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOpenGlobalData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOpenGlobalDataWithCallback invokes the mpaas.CreateOpenGlobalData API asynchronously
func (client *Client) CreateOpenGlobalDataWithCallback(request *CreateOpenGlobalDataRequest, callback func(response *CreateOpenGlobalDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOpenGlobalDataResponse
		var err error
		defer close(result)
		response, err = client.CreateOpenGlobalData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOpenGlobalDataRequest is the request struct for api CreateOpenGlobalData
type CreateOpenGlobalDataRequest struct {
	*requests.RpcRequest
	ExtAttrStr     string           `position:"Body" name:"ExtAttrStr"`
	MinUid         requests.Integer `position:"Body" name:"MinUid"`
	ThirdMsgId     string           `position:"Body" name:"ThirdMsgId"`
	ValidTimeEnd   requests.Integer `position:"Body" name:"ValidTimeEnd"`
	Payload        string           `position:"Body" name:"Payload"`
	Uids           string           `position:"Body" name:"Uids"`
	AppMinVersion  string           `position:"Body" name:"AppMinVersion"`
	ValidTimeStart requests.Integer `position:"Body" name:"ValidTimeStart"`
	MaxUid         requests.Integer `position:"Body" name:"MaxUid"`
	OsType         string           `position:"Body" name:"OsType"`
	BizType        string           `position:"Body" name:"BizType"`
	AppMaxVersion  string           `position:"Body" name:"AppMaxVersion"`
	AppId          string           `position:"Body" name:"AppId"`
	WorkspaceId    string           `position:"Body" name:"WorkspaceId"`
}

// CreateOpenGlobalDataResponse is the response struct for api CreateOpenGlobalData
type CreateOpenGlobalDataResponse struct {
	*responses.BaseResponse
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	Result        bool   `json:"Result" xml:"Result"`
}

// CreateCreateOpenGlobalDataRequest creates a request to invoke CreateOpenGlobalData API
func CreateCreateOpenGlobalDataRequest() (request *CreateOpenGlobalDataRequest) {
	request = &CreateOpenGlobalDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateOpenGlobalData", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateOpenGlobalDataResponse creates a response to parse from CreateOpenGlobalData response
func CreateCreateOpenGlobalDataResponse() (response *CreateOpenGlobalDataResponse) {
	response = &CreateOpenGlobalDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
