package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcubeUpgradePackage invokes the mpaas.CreateMcubeUpgradePackage API synchronously
func (client *Client) CreateMcubeUpgradePackage(request *CreateMcubeUpgradePackageRequest) (response *CreateMcubeUpgradePackageResponse, err error) {
	response = CreateCreateMcubeUpgradePackageResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcubeUpgradePackageWithChan invokes the mpaas.CreateMcubeUpgradePackage API asynchronously
func (client *Client) CreateMcubeUpgradePackageWithChan(request *CreateMcubeUpgradePackageRequest) (<-chan *CreateMcubeUpgradePackageResponse, <-chan error) {
	responseChan := make(chan *CreateMcubeUpgradePackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcubeUpgradePackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcubeUpgradePackageWithCallback invokes the mpaas.CreateMcubeUpgradePackage API asynchronously
func (client *Client) CreateMcubeUpgradePackageWithCallback(request *CreateMcubeUpgradePackageRequest, callback func(response *CreateMcubeUpgradePackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcubeUpgradePackageResponse
		var err error
		defer close(result)
		response, err = client.CreateMcubeUpgradePackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcubeUpgradePackageRequest is the request struct for api CreateMcubeUpgradePackage
type CreateMcubeUpgradePackageRequest struct {
	*requests.RpcRequest
	ValidDays        requests.Integer `position:"Body" name:"ValidDays"`
	BundleId         string           `position:"Body" name:"BundleId"`
	OnexFlag         requests.Boolean `position:"Body" name:"OnexFlag"`
	IsEnterprise     requests.Integer `position:"Body" name:"IsEnterprise"`
	Platform         string           `position:"Body" name:"Platform"`
	TenantId         string           `position:"Body" name:"TenantId"`
	AppstoreUrl      string           `position:"Body" name:"AppstoreUrl"`
	DownloadUrl      string           `position:"Body" name:"DownloadUrl"`
	AppVersion       string           `position:"Body" name:"AppVersion"`
	InstallAmount    requests.Integer `position:"Body" name:"InstallAmount"`
	NeedCheck        requests.Integer `position:"Body" name:"NeedCheck"`
	IosSymbolfileUrl string           `position:"Body" name:"IosSymbolfileUrl"`
	IconFileUrl      string           `position:"Body" name:"IconFileUrl"`
	AppId            string           `position:"Body" name:"AppId"`
	FileUrl          string           `position:"Body" name:"FileUrl"`
	CustomDomainName string           `position:"Body" name:"CustomDomainName"`
	WorkspaceId      string           `position:"Body" name:"WorkspaceId"`
	Desc             string           `position:"Body" name:"Desc"`
}

// CreateMcubeUpgradePackageResponse is the response struct for api CreateMcubeUpgradePackage
type CreateMcubeUpgradePackageResponse struct {
	*responses.BaseResponse
	ResultMessage string                                   `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                   `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                   `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCreateMcubeUpgradePackage `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMcubeUpgradePackageRequest creates a request to invoke CreateMcubeUpgradePackage API
func CreateCreateMcubeUpgradePackageRequest() (request *CreateMcubeUpgradePackageRequest) {
	request = &CreateMcubeUpgradePackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcubeUpgradePackage", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcubeUpgradePackageResponse creates a response to parse from CreateMcubeUpgradePackage response
func CreateCreateMcubeUpgradePackageResponse() (response *CreateMcubeUpgradePackageResponse) {
	response = &CreateMcubeUpgradePackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
