package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMasFunnel invokes the mpaas.CreateMasFunnel API synchronously
func (client *Client) CreateMasFunnel(request *CreateMasFunnelRequest) (response *CreateMasFunnelResponse, err error) {
	response = CreateCreateMasFunnelResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMasFunnelWithChan invokes the mpaas.CreateMasFunnel API asynchronously
func (client *Client) CreateMasFunnelWithChan(request *CreateMasFunnelRequest) (<-chan *CreateMasFunnelResponse, <-chan error) {
	responseChan := make(chan *CreateMasFunnelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMasFunnel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMasFunnelWithCallback invokes the mpaas.CreateMasFunnel API asynchronously
func (client *Client) CreateMasFunnelWithCallback(request *CreateMasFunnelRequest, callback func(response *CreateMasFunnelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMasFunnelResponse
		var err error
		defer close(result)
		response, err = client.CreateMasFunnel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMasFunnelRequest is the request struct for api CreateMasFunnel
type CreateMasFunnelRequest struct {
	*requests.RpcRequest
	TenantId                                  string `position:"Body" name:"TenantId"`
	MpaasMappcenterMcdpMasFunnelCreateJsonStr string `position:"Body" name:"MpaasMappcenterMcdpMasFunnelCreateJsonStr"`
	AppId                                     string `position:"Body" name:"AppId"`
	WorkspaceId                               string `position:"Body" name:"WorkspaceId"`
}

// CreateMasFunnelResponse is the response struct for api CreateMasFunnel
type CreateMasFunnelResponse struct {
	*responses.BaseResponse
	ResultMessage string                         `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                         `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                         `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCreateMasFunnel `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMasFunnelRequest creates a request to invoke CreateMasFunnel API
func CreateCreateMasFunnelRequest() (request *CreateMasFunnelRequest) {
	request = &CreateMasFunnelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMasFunnel", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMasFunnelResponse creates a response to parse from CreateMasFunnel response
func CreateCreateMasFunnelResponse() (response *CreateMasFunnelResponse) {
	response = &CreateMasFunnelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
