package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CrossAccountVerifyToken invokes the market.CrossAccountVerifyToken API synchronously
func (client *Client) CrossAccountVerifyToken(request *CrossAccountVerifyTokenRequest) (response *CrossAccountVerifyTokenResponse, err error) {
	response = CreateCrossAccountVerifyTokenResponse()
	err = client.DoAction(request, response)
	return
}

// CrossAccountVerifyTokenWithChan invokes the market.CrossAccountVerifyToken API asynchronously
func (client *Client) CrossAccountVerifyTokenWithChan(request *CrossAccountVerifyTokenRequest) (<-chan *CrossAccountVerifyTokenResponse, <-chan error) {
	responseChan := make(chan *CrossAccountVerifyTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CrossAccountVerifyToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CrossAccountVerifyTokenWithCallback invokes the market.CrossAccountVerifyToken API asynchronously
func (client *Client) CrossAccountVerifyTokenWithCallback(request *CrossAccountVerifyTokenRequest, callback func(response *CrossAccountVerifyTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CrossAccountVerifyTokenResponse
		var err error
		defer close(result)
		response, err = client.CrossAccountVerifyToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CrossAccountVerifyTokenRequest is the request struct for api CrossAccountVerifyToken
type CrossAccountVerifyTokenRequest struct {
	*requests.RpcRequest
	Token string `position:"Body" name:"Token"`
}

// CrossAccountVerifyTokenResponse is the response struct for api CrossAccountVerifyToken
type CrossAccountVerifyTokenResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCrossAccountVerifyTokenRequest creates a request to invoke CrossAccountVerifyToken API
func CreateCrossAccountVerifyTokenRequest() (request *CrossAccountVerifyTokenRequest) {
	request = &CrossAccountVerifyTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "CrossAccountVerifyToken", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCrossAccountVerifyTokenResponse creates a response to parse from CrossAccountVerifyToken response
func CreateCrossAccountVerifyTokenResponse() (response *CrossAccountVerifyTokenResponse) {
	response = &CrossAccountVerifyTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
