package lubancloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitGenerateTask invokes the lubancloud.SubmitGenerateTask API synchronously
// api document: https://help.aliyun.com/api/lubancloud/submitgeneratetask.html
func (client *Client) SubmitGenerateTask(request *SubmitGenerateTaskRequest) (response *SubmitGenerateTaskResponse, err error) {
	response = CreateSubmitGenerateTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitGenerateTaskWithChan invokes the lubancloud.SubmitGenerateTask API asynchronously
// api document: https://help.aliyun.com/api/lubancloud/submitgeneratetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitGenerateTaskWithChan(request *SubmitGenerateTaskRequest) (<-chan *SubmitGenerateTaskResponse, <-chan error) {
	responseChan := make(chan *SubmitGenerateTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitGenerateTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitGenerateTaskWithCallback invokes the lubancloud.SubmitGenerateTask API asynchronously
// api document: https://help.aliyun.com/api/lubancloud/submitgeneratetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SubmitGenerateTaskWithCallback(request *SubmitGenerateTaskRequest, callback func(response *SubmitGenerateTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitGenerateTaskResponse
		var err error
		defer close(result)
		response, err = client.SubmitGenerateTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitGenerateTaskRequest is the request struct for api SubmitGenerateTask
type SubmitGenerateTaskRequest struct {
	*requests.RpcRequest
	ImageCount     requests.Integer `position:"Query" name:"ImageCount"`
	ActionPoint    string           `position:"Query" name:"ActionPoint"`
	LogoImagePath  string           `position:"Query" name:"LogoImagePath"`
	Type           requests.Integer `position:"Query" name:"Type"`
	MajorImagePath *[]string        `position:"Query" name:"MajorImagePath"  type:"Repeated"`
	Width          requests.Integer `position:"Query" name:"Width"`
	CopyWrite      *[]string        `position:"Query" name:"CopyWrite"  type:"Repeated"`
	PropertyId     *[]string        `position:"Query" name:"PropertyId"  type:"Repeated"`
	Height         requests.Integer `position:"Query" name:"Height"`
}

// SubmitGenerateTaskResponse is the response struct for api SubmitGenerateTask
type SubmitGenerateTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    int    `json:"TaskId" xml:"TaskId"`
}

// CreateSubmitGenerateTaskRequest creates a request to invoke SubmitGenerateTask API
func CreateSubmitGenerateTaskRequest() (request *SubmitGenerateTaskRequest) {
	request = &SubmitGenerateTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lubancloud", "2018-05-09", "SubmitGenerateTask", "luban", "openAPI")
	return
}

// CreateSubmitGenerateTaskResponse creates a response to parse from SubmitGenerateTask response
func CreateSubmitGenerateTaskResponse() (response *SubmitGenerateTaskResponse) {
	response = &SubmitGenerateTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
