package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryBlockchainMetadata invokes the lto.QueryBlockchainMetadata API synchronously
func (client *Client) QueryBlockchainMetadata(request *QueryBlockchainMetadataRequest) (response *QueryBlockchainMetadataResponse, err error) {
	response = CreateQueryBlockchainMetadataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryBlockchainMetadataWithChan invokes the lto.QueryBlockchainMetadata API asynchronously
func (client *Client) QueryBlockchainMetadataWithChan(request *QueryBlockchainMetadataRequest) (<-chan *QueryBlockchainMetadataResponse, <-chan error) {
	responseChan := make(chan *QueryBlockchainMetadataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryBlockchainMetadata(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryBlockchainMetadataWithCallback invokes the lto.QueryBlockchainMetadata API asynchronously
func (client *Client) QueryBlockchainMetadataWithCallback(request *QueryBlockchainMetadataRequest, callback func(response *QueryBlockchainMetadataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryBlockchainMetadataResponse
		var err error
		defer close(result)
		response, err = client.QueryBlockchainMetadata(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryBlockchainMetadataRequest is the request struct for api QueryBlockchainMetadata
type QueryBlockchainMetadataRequest struct {
	*requests.RpcRequest
	ContractName  string `position:"Query" name:"ContractName"`
	BizChainId    string `position:"Query" name:"BizChainId"`
	TransactionId string `position:"Query" name:"TransactionId"`
	InvokeType    string `position:"Query" name:"InvokeType"`
	IotDataDID    string `position:"Query" name:"IotDataDID"`
}

// QueryBlockchainMetadataResponse is the response struct for api QueryBlockchainMetadata
type QueryBlockchainMetadataResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryBlockchainMetadataRequest creates a request to invoke QueryBlockchainMetadata API
func CreateQueryBlockchainMetadataRequest() (request *QueryBlockchainMetadataRequest) {
	request = &QueryBlockchainMetadataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "QueryBlockchainMetadata", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryBlockchainMetadataResponse creates a response to parse from QueryBlockchainMetadata response
func CreateQueryBlockchainMetadataResponse() (response *QueryBlockchainMetadataResponse) {
	response = &QueryBlockchainMetadataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
