package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDashboardDeviceInfo invokes the lto.DescribeDashboardDeviceInfo API synchronously
func (client *Client) DescribeDashboardDeviceInfo(request *DescribeDashboardDeviceInfoRequest) (response *DescribeDashboardDeviceInfoResponse, err error) {
	response = CreateDescribeDashboardDeviceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDashboardDeviceInfoWithChan invokes the lto.DescribeDashboardDeviceInfo API asynchronously
func (client *Client) DescribeDashboardDeviceInfoWithChan(request *DescribeDashboardDeviceInfoRequest) (<-chan *DescribeDashboardDeviceInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDashboardDeviceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDashboardDeviceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDashboardDeviceInfoWithCallback invokes the lto.DescribeDashboardDeviceInfo API asynchronously
func (client *Client) DescribeDashboardDeviceInfoWithCallback(request *DescribeDashboardDeviceInfoRequest, callback func(response *DescribeDashboardDeviceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDashboardDeviceInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDashboardDeviceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDashboardDeviceInfoRequest is the request struct for api DescribeDashboardDeviceInfo
type DescribeDashboardDeviceInfoRequest struct {
	*requests.RpcRequest
}

// DescribeDashboardDeviceInfoResponse is the response struct for api DescribeDashboardDeviceInfo
type DescribeDashboardDeviceInfoResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateDescribeDashboardDeviceInfoRequest creates a request to invoke DescribeDashboardDeviceInfo API
func CreateDescribeDashboardDeviceInfoRequest() (request *DescribeDashboardDeviceInfoRequest) {
	request = &DescribeDashboardDeviceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeDashboardDeviceInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDashboardDeviceInfoResponse creates a response to parse from DescribeDashboardDeviceInfo response
func CreateDescribeDashboardDeviceInfoResponse() (response *DescribeDashboardDeviceInfoResponse) {
	response = &DescribeDashboardDeviceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
