package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMember invokes the lto.AddMember API synchronously
func (client *Client) AddMember(request *AddMemberRequest) (response *AddMemberResponse, err error) {
	response = CreateAddMemberResponse()
	err = client.DoAction(request, response)
	return
}

// AddMemberWithChan invokes the lto.AddMember API asynchronously
func (client *Client) AddMemberWithChan(request *AddMemberRequest) (<-chan *AddMemberResponse, <-chan error) {
	responseChan := make(chan *AddMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMemberWithCallback invokes the lto.AddMember API asynchronously
func (client *Client) AddMemberWithCallback(request *AddMemberRequest, callback func(response *AddMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMemberResponse
		var err error
		defer close(result)
		response, err = client.AddMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMemberRequest is the request struct for api AddMember
type AddMemberRequest struct {
	*requests.RpcRequest
	Remark                string           `position:"Query" name:"Remark"`
	Uid                   string           `position:"Query" name:"Uid"`
	Telephony             string           `position:"Query" name:"Telephony"`
	Name                  string           `position:"Query" name:"Name"`
	AuthorizedDeviceCount requests.Integer `position:"Query" name:"AuthorizedDeviceCount"`
	Contactor             string           `position:"Query" name:"Contactor"`
	AuthorizedCount       requests.Integer `position:"Query" name:"AuthorizedCount"`
}

// AddMemberResponse is the response struct for api AddMember
type AddMemberResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateAddMemberRequest creates a request to invoke AddMember API
func CreateAddMemberRequest() (request *AddMemberRequest) {
	request = &AddMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "AddMember", "", "")
	request.Method = requests.POST
	return
}

// CreateAddMemberResponse creates a response to parse from AddMember response
func CreateAddMemberResponse() (response *AddMemberResponse) {
	response = &AddMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
