package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadMPCoSPhaseDigestInfo invokes the ltl.UploadMPCoSPhaseDigestInfo API synchronously
func (client *Client) UploadMPCoSPhaseDigestInfo(request *UploadMPCoSPhaseDigestInfoRequest) (response *UploadMPCoSPhaseDigestInfoResponse, err error) {
	response = CreateUploadMPCoSPhaseDigestInfoResponse()
	err = client.DoAction(request, response)
	return
}

// UploadMPCoSPhaseDigestInfoWithChan invokes the ltl.UploadMPCoSPhaseDigestInfo API asynchronously
func (client *Client) UploadMPCoSPhaseDigestInfoWithChan(request *UploadMPCoSPhaseDigestInfoRequest) (<-chan *UploadMPCoSPhaseDigestInfoResponse, <-chan error) {
	responseChan := make(chan *UploadMPCoSPhaseDigestInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadMPCoSPhaseDigestInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadMPCoSPhaseDigestInfoWithCallback invokes the ltl.UploadMPCoSPhaseDigestInfo API asynchronously
func (client *Client) UploadMPCoSPhaseDigestInfoWithCallback(request *UploadMPCoSPhaseDigestInfoRequest, callback func(response *UploadMPCoSPhaseDigestInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadMPCoSPhaseDigestInfoResponse
		var err error
		defer close(result)
		response, err = client.UploadMPCoSPhaseDigestInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadMPCoSPhaseDigestInfoRequest is the request struct for api UploadMPCoSPhaseDigestInfo
type UploadMPCoSPhaseDigestInfoRequest struct {
	*requests.RpcRequest
	PhaseData       string                 `position:"Query" name:"PhaseData"`
	PhaseId         string                 `position:"Query" name:"PhaseId"`
	ApiVersion      string                 `position:"Query" name:"ApiVersion"`
	BizChainId      string                 `position:"Query" name:"BizChainId"`
	DataKey         string                 `position:"Query" name:"DataKey"`
	DataSeq         string                 `position:"Query" name:"DataSeq"`
	PhaseGroupId    string                 `position:"Query" name:"PhaseGroupId"`
	RelatedDataList map[string]interface{} `position:"Query" name:"RelatedDataList"`
}

// UploadMPCoSPhaseDigestInfoResponse is the response struct for api UploadMPCoSPhaseDigestInfo
type UploadMPCoSPhaseDigestInfoResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUploadMPCoSPhaseDigestInfoRequest creates a request to invoke UploadMPCoSPhaseDigestInfo API
func CreateUploadMPCoSPhaseDigestInfoRequest() (request *UploadMPCoSPhaseDigestInfoRequest) {
	request = &UploadMPCoSPhaseDigestInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "UploadMPCoSPhaseDigestInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadMPCoSPhaseDigestInfoResponse creates a response to parse from UploadMPCoSPhaseDigestInfo response
func CreateUploadMPCoSPhaseDigestInfoResponse() (response *UploadMPCoSPhaseDigestInfoResponse) {
	response = &UploadMPCoSPhaseDigestInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
